/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import net.minecraft.class_1799;

public abstract class UpgradeBase
implements IUpgrade {
    public UpgradeManager upgradeManager;
    public int dataHolderSlot;
    public Point openTabSize;

    public UpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize) {
        this.upgradeManager = manager;
        this.dataHolderSlot = dataHolderSlot;
        this.openTabSize = openTabSize;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public int getDataHolderSlot() {
        return this.dataHolderSlot;
    }

    @Override
    public boolean isTabOpened() {
        return NbtHelper.getOrDefault(this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "TabOpen", false);
    }

    public class_1799 getDataHolderStack() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot);
    }

    @Override
    public Point getTabSize() {
        if (this.isTabOpened()) {
            UpgradeBase upgradeBase = this;
            if (upgradeBase instanceof IFilter) {
                IFilter filter = (IFilter)((Object)upgradeBase);
                int rowCount = (int)Math.ceil((double)filter.getFilterSlotCount() / 3.0);
                return new Point(this.openTabSize.x(), this.openTabSize.y() - 18 * (3 - rowCount));
            }
            return this.openTabSize;
        }
        return new Point(24, 24);
    }

    public void setCooldown(int cooldown) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        NbtHelper.set(dataHolderStack, "Cooldown", cooldown);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public int getCooldown() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "Cooldown", 100);
    }
}

