/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.IPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerboundAbilitySliderPacket
implements IPacket<ServerboundAbilitySliderPacket> {
    private final byte screenID;
    private final boolean sliderValue;

    public ServerboundAbilitySliderPacket(byte screenID, boolean sliderValue) {
        this.screenID = screenID;
        this.sliderValue = sliderValue;
    }

    public static ServerboundAbilitySliderPacket decode(class_2540 buffer) {
        byte screenID = buffer.readByte();
        boolean sliderValue = buffer.readBoolean();
        return new ServerboundAbilitySliderPacket(screenID, sliderValue);
    }

    @Override
    public void encode(ServerboundAbilitySliderPacket message, class_2540 buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.sliderValue);
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.ABILITY_SLIDER_ID;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundAbilitySliderPacket message = ServerboundAbilitySliderPacket.decode(buf);
        server.execute(() -> {
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper((class_1657)player);
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)patt0$temp;
                wrapper = menu.getWrapper();
            }
            ServerActions.switchAbilitySlider(wrapper, message.sliderValue);
            wrapper.sendDataToClients("AbilityEnabled");
        });
    }
}

