/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.network.IPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerboundEquipBackpackPacket
implements IPacket<ServerboundEquipBackpackPacket> {
    private final boolean equip;

    public ServerboundEquipBackpackPacket(boolean equip) {
        this.equip = equip;
    }

    public static ServerboundEquipBackpackPacket decode(class_2540 buffer) {
        boolean equip = buffer.readBoolean();
        return new ServerboundEquipBackpackPacket(equip);
    }

    @Override
    public void encode(ServerboundEquipBackpackPacket message, class_2540 buffer) {
        buffer.writeBoolean(message.equip);
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.EQUIP_BACKPACK_ID;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundEquipBackpackPacket message = ServerboundEquipBackpackPacket.decode(buf);
        server.execute(() -> {
            if (message.equip) {
                ServerActions.equipBackpack((class_1657)player);
            } else {
                ServerActions.unequipBackpack((class_1657)player);
            }
        });
    }
}

