/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.IPacket;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerboundTabPacket
implements IPacket<ServerboundTabPacket> {
    private final int slot;
    private final boolean open;
    private final int packetType;
    public static final int TAB_OPEN = 0;
    public static final int UPGRADE_ENABLED = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int PLAY_RECORD = 3;

    public ServerboundTabPacket(int slot, boolean open, int packetType) {
        this.slot = slot;
        this.open = open;
        this.packetType = packetType;
    }

    public static ServerboundTabPacket decode(class_2540 buffer) {
        int slot = buffer.readInt();
        boolean open = buffer.readBoolean();
        int packetType = buffer.readInt();
        return new ServerboundTabPacket(slot, open, packetType);
    }

    @Override
    public void encode(ServerboundTabPacket message, class_2540 buffer) {
        buffer.writeInt(message.slot);
        buffer.writeBoolean(message.open);
        buffer.writeInt(message.packetType);
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.TAB_ID;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundTabPacket message = ServerboundTabPacket.decode(buf);
        server.execute(() -> {
            BackpackBaseMenu menu;
            class_1799 upgradeStack;
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof BackpackBaseMenu && !(upgradeStack = (menu = (BackpackBaseMenu)patt0$temp).getWrapper().getUpgrades().getStackInSlot(message.slot)).method_7960()) {
                class_1799 updateStack = upgradeStack.method_7972();
                NbtHelper.set(updateStack, ServerboundTabPacket.getPacketType(message.packetType), message.open);
                menu.getWrapper().getUpgrades().setStackInSlot(message.slot, updateStack);
            }
        });
    }

    public static String getPacketType(int type) {
        return switch (type) {
            case 0 -> "TabOpen";
            case 1 -> "UpgradeEnabled";
            case 2 -> "ShiftClickToBackpack";
            case 3 -> "IsPlaying";
            default -> "TabOpen";
        };
    }
}

