/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.client;

import java.util.HashSet;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.registry.CustomBlockEntityRendererRegistry;
import wraith.fwaystones.registry.CustomScreenRegistry;
import wraith.fwaystones.registry.ItemRegistry;
import wraith.fwaystones.registry.WaystonesModelProviderRegistry;
import wraith.fwaystones.screen.UniversalWaystoneScreenHandler;
import wraith.fwaystones.util.WaystonePacketHandler;
import wraith.fwaystones.util.WaystoneStorage;

@Environment(value=EnvType.CLIENT)
public class WaystonesClient
implements ClientModInitializer {
    public void onInitializeClient() {
        CustomBlockEntityRendererRegistry.RegisterBlockEntityRenderers();
        CustomScreenRegistry.registerScreens();
        WaystonesModelProviderRegistry.register();
        this.registerPacketHandlers();
        this.registerEvents();
    }

    private void registerPacketHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WaystonePacketHandler.WAYSTONE_PACKET, (client, networkHandler, data, sender) -> {
            class_2487 nbt = data.method_10798();
            client.execute(() -> {
                if (FabricWaystones.WAYSTONE_STORAGE == null) {
                    FabricWaystones.WAYSTONE_STORAGE = new WaystoneStorage(null);
                }
                FabricWaystones.WAYSTONE_STORAGE.fromTag(nbt);
                if (client.field_1724 == null) {
                    return;
                }
                HashSet<String> toForget = new HashSet<String>();
                for (String hash : ((PlayerEntityMixinAccess)client.field_1724).getDiscoveredWaystones()) {
                    if (FabricWaystones.WAYSTONE_STORAGE.containsHash(hash)) continue;
                    toForget.add(hash);
                }
                ((PlayerEntityMixinAccess)client.field_1724).forgetWaystones(toForget);
                if (client.field_1724.field_7512 instanceof UniversalWaystoneScreenHandler) {
                    ((UniversalWaystoneScreenHandler)client.field_1724.field_7512).updateWaystones((class_1657)client.field_1724);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WaystonePacketHandler.SYNC_PLAYER, (client, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            client.execute(() -> {
                if (client.field_1724 != null) {
                    ((PlayerEntityMixinAccess)client.field_1724).fromTagW(tag);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WaystonePacketHandler.VOID_REVIVE, (client, handler, packet, sender) -> {
            if (client.field_1724 == null) {
                return;
            }
            client.execute(() -> {
                client.field_1713.method_3051((class_1297)client.field_1724, (class_2394)class_2398.field_11220, 30);
                handler.method_2890().method_8486(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), class_3417.field_14931, client.field_1724.method_5634(), 1.0f, 1.0f, false);
                for (int i = 0; i < client.field_1724.method_31548().method_5439(); ++i) {
                    class_1799 playerStack = client.field_1724.method_31548().method_5438(i);
                    if (playerStack.method_7909() != ItemRegistry.get("void_totem")) continue;
                    client.field_1773.method_3189(playerStack);
                    break;
                }
            });
        });
    }

    public void registerEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (FabricWaystones.WAYSTONE_STORAGE == null) {
                FabricWaystones.WAYSTONE_STORAGE = new WaystoneStorage(null);
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (FabricWaystones.WAYSTONE_STORAGE == null) {
                FabricWaystones.LOGGER.error("The Waystone storage is null. This is likely caused by a crash.");
                return;
            }
            FabricWaystones.WAYSTONE_STORAGE.loadOrSaveWaystones(true);
            FabricWaystones.WAYSTONE_STORAGE = null;
        });
    }
}

