/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.PlaceholderCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.api.utils.OptionUtils;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.OptionDescriptionWidget;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.SearchFieldWidget;
import dev.isxander.yacl3.gui.tab.ListHolderWidget;
import dev.isxander.yacl3.gui.tab.ScrollableNavigationBar;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5489;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import net.minecraft.class_8002;
import net.minecraft.class_8030;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import org.jetbrains.annotations.Nullable;

public class YACLScreen
extends class_437 {
    public final YetAnotherConfigLib config;
    private final class_437 parent;
    public final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    public class_8089 tabNavigationBar;
    public class_8030 tabArea;
    public class_2561 saveButtonMessage;
    public class_2561 saveButtonTooltipMessage;
    private int saveButtonMessageTime;

    public YACLScreen(YetAnotherConfigLib config, class_437 parent) {
        super(config.title());
        this.config = config;
        this.parent = parent;
    }

    protected void method_25426() {
        int currentTab;
        int n = currentTab = this.tabNavigationBar != null ? this.tabNavigationBar.field_42147.indexOf((Object)this.tabManager.method_48614()) : 0;
        if (currentTab == -1) {
            currentTab = 0;
        }
        this.tabNavigationBar = new ScrollableNavigationBar(this.field_22789, this.tabManager, this.config.categories().stream().map(category -> {
            if (category instanceof PlaceholderCategory) {
                PlaceholderCategory placeholder = (PlaceholderCategory)category;
                return new PlaceholderTab(placeholder);
            }
            return new CategoryTab((ConfigCategory)category);
        }).toList());
        this.tabNavigationBar.method_48987(currentTab, false);
        this.tabNavigationBar.method_49613();
        class_8030 navBarArea = this.tabNavigationBar.method_48202();
        this.tabArea = new class_8030(0, navBarArea.comp_1197() - 1, this.field_22789, this.field_22790 - navBarArea.comp_1197() + 1);
        this.tabManager.method_48616(this.tabArea);
        this.method_37063((class_364)this.tabNavigationBar);
        this.config.initConsumer().accept(this);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25434(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    protected void finishOrSave() {
        this.saveButtonMessage = null;
        if (this.pendingChanges()) {
            HashSet flags = new HashSet();
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.applyValue()) {
                    flags.addAll(option.flags());
                }
            });
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.changed()) {
                    option.forgetPendingValue();
                    YACLConstants.LOGGER.error("Option '{}' value mismatch after applying! Reset to binding's getter.", (Object)option.name().getString());
                }
            });
            this.config.saveFunction().run();
            flags.forEach(flag -> flag.accept(this.field_22787));
        } else {
            this.method_25419();
        }
    }

    protected void cancelOrReset() {
        if (this.pendingChanges()) {
            OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
            this.method_25419();
        } else {
            OptionUtils.forEachOptions(this.config, Option::requestSetDefault);
        }
    }

    protected void undo() {
        OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
    }

    public void method_25393() {
        this.tabManager.method_48617();
        if (this.saveButtonMessage != null) {
            if (this.saveButtonMessageTime > 140) {
                this.saveButtonMessage = null;
                this.saveButtonTooltipMessage = null;
                this.saveButtonMessageTime = 0;
            } else {
                ++this.saveButtonMessageTime;
                if (this.saveButtonTooltipMessage != null) {
                    // empty if block
                }
            }
        }
    }

    private void setSaveButtonMessage(class_2561 message, class_2561 tooltip) {
        this.saveButtonMessage = message;
        this.saveButtonTooltipMessage = tooltip;
        this.saveButtonMessageTime = 0;
    }

    private boolean pendingChanges() {
        AtomicBoolean pendingChanges = new AtomicBoolean(false);
        OptionUtils.consumeOptions(this.config, option -> {
            if (option.changed()) {
                pendingChanges.set(true);
                return true;
            }
            return false;
        });
        return pendingChanges.get();
    }

    public boolean method_25422() {
        if (this.pendingChanges()) {
            this.setSaveButtonMessage((class_2561)class_2561.method_43471((String)"yacl.gui.save_before_exit").method_27692(class_124.field_1061), (class_2561)class_2561.method_43471((String)"yacl.gui.save_before_exit.tooltip"));
            return false;
        }
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public static void renderMultilineTooltip(class_332 graphics, class_327 font, class_5489 text, int centerX, int yAbove, int yBelow, int screenWidth, int screenHeight) {
        if (text.method_30887() > 0) {
            int maxWidth = text.method_44048();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int height = text.method_30887() * lineHeight - 1;
            int belowY = yBelow + 12;
            int aboveY = yAbove - height + 12;
            int maxBelow = screenHeight - (belowY + height);
            int minAbove = aboveY - height;
            int y = aboveY;
            if (minAbove < 8) {
                y = maxBelow > minAbove ? belowY : aboveY;
            }
            int x = Math.max(centerX - text.method_44048() / 2 - 12, -6);
            int drawX = x + 12;
            int drawY = y - 12;
            graphics.method_51448().method_22903();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            RenderSystem.setShader(class_757::method_34540);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            class_8002.method_47946((class_332)graphics, (int)drawX, (int)drawY, (int)maxWidth, (int)height, (int)400);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.disableBlend();
            graphics.method_51448().method_22904(0.0, 0.0, 400.0);
            text.method_30893(graphics, drawX, drawY, lineHeight, -1);
            graphics.method_51448().method_22909();
        }
    }

    public class PlaceholderTab
    implements TabExt {
        private final PlaceholderCategory category;
        private final class_7919 tooltip;

        public PlaceholderTab(PlaceholderCategory category) {
            this.category = category;
            this.tooltip = class_7919.method_47407((class_2561)category.tooltip());
        }

        public class_2561 method_48610() {
            return this.category.name();
        }

        public void method_48612(Consumer<class_339> consumer) {
        }

        public void method_48611(class_8030 screenRectangle) {
            YACLScreen.this.field_22787.method_1507(this.category.screen().apply(YACLScreen.this.field_22787, YACLScreen.this));
        }

        @Override
        @Nullable
        public class_7919 getTooltip() {
            return this.tooltip;
        }
    }

    public class CategoryTab
    implements TabExt {
        private final ConfigCategory category;
        private final class_7919 tooltip;
        private ListHolderWidget<OptionListWidget> optionList;
        private final class_4185 saveFinishedButton;
        private final class_4185 cancelResetButton;
        private final class_4185 undoButton;
        private final SearchFieldWidget searchField;
        private OptionDescriptionWidget descriptionWidget;

        public CategoryTab(ConfigCategory category) {
            this.category = category;
            this.tooltip = class_7919.method_47407((class_2561)category.tooltip());
            int columnWidth = YACLScreen.this.field_22789 / 3;
            int padding = columnWidth / 20;
            columnWidth = Math.min(columnWidth, 400);
            int paddedWidth = columnWidth - padding * 2;
            MutableDimension<Integer> actionDim = Dimension.ofInt(YACLScreen.this.field_22789 / 3 * 2 + YACLScreen.this.field_22789 / 6, YACLScreen.this.field_22790 - padding - 20, paddedWidth, 20);
            this.saveFinishedButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> YACLScreen.this.finishOrSave()).method_46433((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).method_46437(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).method_46431();
            actionDim.expand(-((Integer)actionDim.width()).intValue() / 2 - 2, 0).move(-((Integer)actionDim.width()).intValue() / 2 - 2, -22);
            this.cancelResetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), btn -> YACLScreen.this.cancelOrReset()).method_46433((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).method_46437(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).method_46431();
            actionDim.move((Integer)actionDim.width() + 4, 0);
            this.undoButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"yacl.gui.undo"), btn -> YACLScreen.this.undo()).method_46433((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).method_46437(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"yacl.gui.undo.tooltip"))).method_46431();
            this.searchField = new SearchFieldWidget(YACLScreen.this, YACLScreen.this.field_22793, YACLScreen.this.field_22789 / 3 * 2 + YACLScreen.this.field_22789 / 6 - paddedWidth / 2 + 1, this.undoButton.method_46427() - 22, paddedWidth - 2, 18, (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"), (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"), searchQuery -> this.optionList.getList().updateSearchQuery((String)searchQuery));
            this.optionList = new ListHolderWidget<OptionListWidget>(() -> new class_8030(YACLScreen.this.tabArea.comp_1195(), YACLScreen.this.tabArea.comp_1196() / 3 * 2 + 1, YACLScreen.this.tabArea.comp_1197()), new OptionListWidget(YACLScreen.this, category, YACLScreen.this.field_22787, 0, 0, YACLScreen.this.field_22789 / 3 * 2 + 1, YACLScreen.this.field_22790, desc -> this.descriptionWidget.setOptionDescription((DescriptionWithName)desc)));
            this.descriptionWidget = new OptionDescriptionWidget(() -> new class_8030(YACLScreen.this.field_22789 / 3 * 2 + padding, YACLScreen.this.tabArea.method_49618() + padding, paddedWidth, this.searchField.method_46427() - 1 - YACLScreen.this.tabArea.method_49618() - padding * 2), null);
            this.updateButtons();
        }

        public class_2561 method_48610() {
            return this.category.name();
        }

        public void method_48612(Consumer<class_339> consumer) {
            consumer.accept(this.optionList);
            consumer.accept((class_339)this.saveFinishedButton);
            consumer.accept((class_339)this.cancelResetButton);
            consumer.accept((class_339)this.undoButton);
            consumer.accept((class_339)this.searchField);
            consumer.accept(this.descriptionWidget);
        }

        public void method_48611(class_8030 screenRectangle) {
        }

        public void method_48613() {
            this.updateButtons();
            this.searchField.method_1865();
            this.descriptionWidget.tick();
        }

        @Override
        @Nullable
        public class_7919 getTooltip() {
            return this.tooltip;
        }

        private void updateButtons() {
            boolean pendingChanges;
            this.undoButton.field_22763 = pendingChanges = YACLScreen.this.pendingChanges();
            this.saveFinishedButton.method_25355((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.save") : GuiUtils.translatableFallback("yacl.gui.done", class_5244.field_24334)));
            this.saveFinishedButton.method_47400(class_7919.method_47407((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.save.tooltip") : class_2561.method_43471((String)"yacl.gui.finished.tooltip"))));
            this.cancelResetButton.method_25355((class_2561)(pendingChanges ? GuiUtils.translatableFallback("yacl.gui.cancel", class_5244.field_24335) : class_2561.method_43471((String)"controls.reset")));
            this.cancelResetButton.method_47400(class_7919.method_47407((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.cancel.tooltip") : class_2561.method_43471((String)"yacl.gui.reset.tooltip"))));
        }
    }
}

