/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageRendererManager {
    private static final ExecutorService SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(task -> new Thread(task, "YACL Image Prep"));
    private static final Map<class_2960, CompletableFuture<ImageRenderer>> IMAGE_CACHE = new ConcurrentHashMap<class_2960, CompletableFuture<ImageRenderer>>();

    public static <T extends ImageRenderer> CompletableFuture<T> registerImage(class_2960 id, ImageRendererFactory<T> factory) {
        if (IMAGE_CACHE.containsKey(id)) {
            return IMAGE_CACHE.get(id);
        }
        CompletableFuture future = new CompletableFuture();
        IMAGE_CACHE.put(id, future);
        SINGLE_THREAD_EXECUTOR.submit(() -> {
            Supplier supplier = factory.requiresOffThreadPreparation() ? new CompletedSupplier(ImageRendererManager.safelyPrepareFactory(id, factory)) : () -> ImageRendererManager.safelyPrepareFactory(id, factory);
            class_310.method_1551().execute(() -> ImageRendererManager.completeImageFactory(id, supplier, future));
        });
        return future;
    }

    private static <T extends ImageRenderer> void completeImageFactory(class_2960 id, Supplier<Optional<ImageRendererFactory.ImageSupplier<T>>> supplier, CompletableFuture<ImageRenderer> future) {
        Object image;
        RenderSystem.assertOnRenderThread();
        ImageRendererFactory.ImageSupplier completableImage = supplier.get().orElse(null);
        if (completableImage == null) {
            return;
        }
        if (future.isDone()) {
            YACLConstants.LOGGER.error("Image '{}' was already completed", (Object)id);
            return;
        }
        try {
            image = completableImage.completeImage();
        }
        catch (Exception e) {
            YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)id, (Object)e);
            return;
        }
        future.complete((ImageRenderer)image);
    }

    public static void closeAll() {
        SINGLE_THREAD_EXECUTOR.shutdownNow();
        IMAGE_CACHE.values().removeIf(future -> {
            if (future.isDone()) {
                ((ImageRenderer)future.join()).close();
            }
            return true;
        });
    }

    private static <T extends ImageRenderer> Optional<ImageRendererFactory.ImageSupplier<T>> safelyPrepareFactory(class_2960 id, ImageRendererFactory<T> factory) {
        try {
            return Optional.of(factory.prepareImage());
        }
        catch (Exception e) {
            YACLConstants.LOGGER.error("Failed to prepare image '{}'", (Object)id, (Object)e);
            IMAGE_CACHE.remove(id);
            return Optional.empty();
        }
    }

    private record CompletedSupplier<T>(T get) implements Supplier<T>
    {
    }
}

