/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import de.rubixdev.inventorio.api.InventorioAPI;
import de.rubixdev.inventorio.player.PlayerInventoryAddon;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class InventorioCompat
implements InvModCompat<class_2371<class_3545<class_1799, DropRule>>> {
    @Override
    public String getModName() {
        return "inventorio";
    }

    @Override
    public void clear(class_3222 player) {
        PlayerInventoryAddon inventoryAddon = InventorioAPI.getInventoryAddon((class_1657)player);
        if (inventoryAddon == null) {
            return;
        }
        inventoryAddon.method_5448();
    }

    @Override
    public CompatComponent<class_2371<class_3545<class_1799, DropRule>>> readNbt(class_2487 nbt) {
        class_2371<class_3545<class_1799, DropRule>> items = InventoryComponent.listFromNbt(nbt, itemNbt -> {
            class_1799 stack = class_1799.method_7915((class_2487)itemNbt);
            DropRule dropRule = itemNbt.method_10545("dropRule") ? DropRule.valueOf(itemNbt.method_10558("dropRule")) : YigdConfig.getConfig().compatConfig.defaultInventorioDropRule;
            return new class_3545((Object)stack, (Object)dropRule);
        }, InventoryComponent.EMPTY_ITEM_PAIR);
        return new InventorioCompatComponent(items);
    }

    @Override
    public CompatComponent<class_2371<class_3545<class_1799, DropRule>>> getNewComponent(class_3222 player) {
        return new InventorioCompatComponent(player);
    }

    private static class InventorioCompatComponent
    extends CompatComponent<class_2371<class_3545<class_1799, DropRule>>> {
        public InventorioCompatComponent(class_3222 player) {
            super(player);
        }

        public InventorioCompatComponent(class_2371<class_3545<class_1799, DropRule>> inventory) {
            super(inventory);
        }

        @Override
        public class_2371<class_3545<class_1799, DropRule>> getInventory(class_3222 player) {
            PlayerInventoryAddon addon = InventorioAPI.getInventoryAddon((class_1657)player);
            class_2371 items = class_2371.method_10211();
            if (addon == null) {
                return items;
            }
            DropRule defaultDropRule = YigdConfig.getConfig().compatConfig.defaultInventorioDropRule;
            for (int i = 0; i < addon.method_5439(); ++i) {
                class_1799 stack = addon.method_5438(i);
                items.add((Object)new class_3545((Object)stack, (Object)defaultDropRule));
            }
            return items;
        }

        @Override
        public class_2371<class_1799> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            class_2371 mergingInventory = (class_2371)mergingComponent.inventory;
            for (int i = 0; i < mergingInventory.size(); ++i) {
                class_1799 mergingItem = ((class_1799)((class_3545)mergingInventory.get(i)).method_15442()).method_7972();
                if (mergingItem.method_7960()) continue;
                class_3545 pair = (class_3545)((class_2371)this.inventory).get(i);
                if (!((class_1799)pair.method_15442()).method_7960()) {
                    extraItems.add((Object)mergingItem);
                    continue;
                }
                ((class_2371)this.inventory).set(i, (Object)new class_3545((Object)mergingItem, (Object)((DropRule)((Object)pair.method_15441()))));
            }
            return extraItems;
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            class_2371 extraItems = class_2371.method_10211();
            PlayerInventoryAddon addon = InventorioAPI.getInventoryAddon((class_1657)player);
            if (addon == null) {
                return extraItems;
            }
            for (int i = 0; i < ((class_2371)this.inventory).size(); ++i) {
                class_1799 item = ((class_1799)((class_3545)((class_2371)this.inventory).get(i)).method_15442()).method_7972();
                if (i >= addon.method_5439()) {
                    extraItems.add((Object)item);
                    continue;
                }
                addon.method_5447(i, item);
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            for (class_3545 pair : (class_2371)this.inventory) {
                class_1799 stack = (class_1799)pair.method_15442();
                if (stack.method_7960()) continue;
                DropRule dropRule = compatConfig.defaultInventorioDropRule;
                if (dropRule == DropRule.PUT_IN_GRAVE) {
                    dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
                }
                pair.method_34965((Object)dropRule);
            }
        }

        @Override
        public class_2371<class_3545<class_1799, DropRule>> getAsStackDropList() {
            class_2371 items = class_2371.method_10211();
            items.addAll((Collection)this.inventory);
            return items;
        }

        @Override
        public CompatComponent<class_2371<class_3545<class_1799, DropRule>>> filterInv(Predicate<DropRule> predicate) {
            class_2371 filteredItems = class_2371.method_10211();
            for (int i = 0; i < ((class_2371)this.inventory).size(); ++i) {
                class_3545 pair = (class_3545)((class_2371)this.inventory).get(i);
                class_1799 stack = (class_1799)pair.method_15442();
                DropRule dropRule = (DropRule)((Object)pair.method_15441());
                if (predicate.test(dropRule)) {
                    filteredItems.add(i, (Object)new class_3545((Object)stack, (Object)dropRule));
                    continue;
                }
                filteredItems.add(i, InventoryComponent.EMPTY_ITEM_PAIR);
            }
            return new InventorioCompatComponent((class_2371<class_3545<class_1799, DropRule>>)filteredItems);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            for (class_3545 pair : (class_2371)this.inventory) {
                class_1799 stack = (class_1799)pair.method_15442();
                if (!predicate.test(stack)) continue;
                stack.method_7934(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Collections.fill((List)this.inventory, InventoryComponent.EMPTY_ITEM_PAIR);
        }

        @Override
        public class_2487 writeNbt() {
            return InventoryComponent.listToNbt((class_2371)this.inventory, pair -> {
                class_2487 itemNbt = new class_2487();
                ((class_1799)pair.method_15442()).method_7953(itemNbt);
                itemNbt.method_10582("dropRule", ((DropRule)((Object)((Object)pair.method_15441()))).name());
                return itemNbt;
            }, pair -> ((class_1799)pair.method_15442()).method_7960());
        }
    }
}

