/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.config.ExpDropBehaviour;
import com.b1n_ry.yigd.config.YigdConfig;
import net.minecraft.class_1303;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ExpComponent {
    private final double originalXp;
    private int storedXp;

    public ExpComponent(class_3222 player) {
        this.originalXp = this.getTotalExperience(player);
        this.storedXp = this.getXpDropAmount(player);
    }

    private ExpComponent(int storedXp, double originalXp) {
        this.storedXp = storedXp;
        this.originalXp = originalXp;
    }

    public void setStoredXp(int storedXp) {
        this.storedXp = storedXp;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public double getOriginalXp() {
        return this.originalXp;
    }

    public int getXpDropAmount(class_3222 player) {
        YigdConfig config = YigdConfig.getConfig();
        double totalExperience = this.getTotalExperience(player);
        int percentageDrop = (int)((double)((float)config.expConfig.dropPercentage / 100.0f) * totalExperience);
        int vanillaDrop = player.method_6110();
        return switch (config.expConfig.dropBehaviour) {
            default -> throw new IncompatibleClassChangeError();
            case ExpDropBehaviour.BEST_OF_BOTH -> Math.max(vanillaDrop, percentageDrop);
            case ExpDropBehaviour.WORST_OF_BOTH -> Math.min(vanillaDrop, percentageDrop);
            case ExpDropBehaviour.PERCENTAGE -> percentageDrop;
            case ExpDropBehaviour.VANILLA -> vanillaDrop;
        };
    }

    private double getTotalExperience(class_3222 player) {
        int currentLevel = player.field_7520;
        double totalExperience = currentLevel >= 32 ? 4.5 * Math.pow(currentLevel, 2.0) - 162.5 * (double)currentLevel + 2220.0 : (currentLevel >= 17 ? 2.5 * Math.pow(currentLevel, 2.0) - 40.5 * (double)currentLevel + 360.0 : Math.pow(currentLevel, 2.0) + (double)(6 * currentLevel));
        return totalExperience += (double)((float)player.method_7349() * player.field_7510);
    }

    public int getXpLevel() {
        return ExpComponent.xpToLevels(this.storedXp);
    }

    public boolean isEmpty() {
        return this.storedXp == 0;
    }

    public ExpComponent getSoulboundExp() {
        YigdConfig config = YigdConfig.getConfig();
        float soulboundFactor = (float)config.expConfig.keepPercentage / 100.0f;
        int keepXp = (int)((float)this.storedXp * soulboundFactor);
        this.storedXp -= keepXp;
        if (this.storedXp < 0) {
            this.storedXp = 0;
        }
        return new ExpComponent(keepXp, this.originalXp);
    }

    public void dropAll(class_3218 world, class_243 pos) {
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)this.storedXp);
    }

    public void applyToPlayer(class_3222 player) {
        player.method_7255(this.storedXp);
    }

    public void clear() {
        this.storedXp = 0;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("value", this.storedXp);
        nbt.method_10549("original", this.originalXp);
        return nbt;
    }

    public static ExpComponent fromNbt(class_2487 nbt) {
        int xpToDrop = nbt.method_10550("value");
        double originalXp = nbt.method_10545("original") ? nbt.method_10574("original") : (double)xpToDrop;
        return new ExpComponent(xpToDrop, originalXp);
    }

    public static void clearXp(class_3222 player) {
        player.field_7495 = 0;
        player.field_7520 = 0;
        player.field_7510 = 0.0f;
    }

    public static int xpToLevels(int totalXp) {
        int i = 0;
        while (totalXp >= 0) {
            totalXp = i < 16 ? (totalXp -= 2 * i + 7) : (i < 31 ? (totalXp -= 5 * i - 38) : (totalXp -= 9 * i - 158));
            ++i;
        }
        return i - 1;
    }

    public ExpComponent copy() {
        return new ExpComponent(this.storedXp, this.originalXp);
    }
}

