/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class AttributeAffix
extends Affix {
    public static final Codec<AttributeAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41190.method_39673().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(class_1322.class_1323.class).fieldOf("operation").forGetter(a -> a.operation), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, AttributeAffix::new));
    protected final class_1320 attribute;
    protected final class_1322.class_1323 operation;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;
    protected final transient Map<LootRarity, ModifierInst> modifiers;

    public AttributeAffix(class_1320 attr, class_1322.class_1323 op, Map<LootRarity, StepFunction> values, Set<LootCategory> types) {
        super(AffixType.STAT);
        this.attribute = attr;
        this.operation = op;
        this.values = values;
        this.types = types;
        this.modifiers = values.entrySet().stream().map(entry -> Pair.of((Object)((LootRarity)entry.getKey()), (Object)new ModifierInst(attr, op, (StepFunction)entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public class_5250 getDescription(class_1799 stack, LootRarity rarity, float level) {
        return class_2561.method_43473();
    }

    @Override
    public class_2561 getAugmentingText(class_1799 stack, LootRarity rarity, float level) {
        ModifierInst modif = this.modifiers.get(rarity);
        double value = modif.valueFactory.get(level);
        class_5250 valueComp = IFormattableAttribute.toValueComponent((class_1320)this.attribute, (class_1322.class_1323)this.operation, (double)(value < 0.0 ? -value : value), (class_1836)AttributesLib.getTooltipFlag());
        class_5250 comp = value > 0.0 ? class_2561.method_43469((String)"zenith_attributes.modifier.plus", (Object[])new Object[]{valueComp, class_2561.method_43471((String)this.attribute.method_26830())}).method_27692(class_124.field_1078) : class_2561.method_43469((String)"zenith_attributes.modifier.take", (Object[])new Object[]{valueComp, class_2561.method_43471((String)this.attribute.method_26830())}).method_27692(class_124.field_1061);
        if (modif.valueFactory.get(0.0f) != modif.valueFactory.get(1.0f)) {
            class_5250 minComp = IFormattableAttribute.toValueComponent((class_1320)this.attribute, (class_1322.class_1323)this.operation, (double)modif.valueFactory.get(0.0f), (class_1836)AttributesLib.getTooltipFlag());
            class_5250 maxComp = IFormattableAttribute.toValueComponent((class_1320)this.attribute, (class_1322.class_1323)this.operation, (double)modif.valueFactory.get(1.0f), (class_1836)AttributesLib.getTooltipFlag());
            comp.method_10852((class_2561)AttributeAffix.valueBounds((class_2561)minComp, (class_2561)maxComp));
        }
        return comp;
    }

    @Override
    public void addModifiers(class_1799 stack, LootRarity rarity, float level, class_1304 type, BiConsumer<class_1320, class_1322> map) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            AdventureModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getId(), (Object)stack.method_7964().getString());
            return;
        }
        ModifierInst modif = this.modifiers.get(rarity);
        if (modif.attr == null) {
            AdventureModule.LOGGER.debug("The affix {} has attempted to apply a null attribute modifier to {}!", (Object)this.getId(), (Object)stack.method_7964().getString());
            return;
        }
        for (class_1304 slot : cat.getSlots()) {
            if (slot != type) continue;
            map.accept(modif.attr, modif.build(stack, this.getId(), level));
        }
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone()) {
            return false;
        }
        return (this.types.isEmpty() || this.types.contains(cat)) && this.modifiers.containsKey(rarity);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public record ModifierInst(class_1320 attr, class_1322.class_1323 op, StepFunction valueFactory) {
        private static UUID getOrCreateUUID(class_1799 stack, class_2960 id) {
            class_2487 tag = stack.method_7941("affix_data");
            return GemItem.getOrCreateUUIDs(tag, 1).get(0);
        }

        public class_1322 build(class_1799 stack, class_2960 id, float level) {
            return new class_1322(ModifierInst.getOrCreateUUID(stack, id), "affix:" + id, (double)this.valueFactory.get(level), this.op);
        }
    }
}

