/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.attributeslib.components.BooleanComponent;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class FestiveAffix
extends Affix {
    public static Codec<FestiveAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, FestiveAffix::new));
    protected final Map<LootRarity, StepFunction> values;
    private static String MARKER = "zenith.equipment";

    public FestiveAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public class_5250 getDescription(class_1799 stack, LootRarity rarity, float level) {
        return class_2561.method_43469((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{FestiveAffix.fmt(100.0f * this.getTrueLevel(rarity, level))});
    }

    @Override
    public class_2561 getAugmentingText(class_1799 stack, LootRarity rarity, float level) {
        class_5250 comp = this.getDescription(stack, rarity, level);
        class_5250 minComp = class_2561.method_43469((String)"%s%%", (Object[])new Object[]{FestiveAffix.fmt(100.0f * this.getTrueLevel(rarity, 0.0f))});
        class_5250 maxComp = class_2561.method_43469((String)"%s%%", (Object[])new Object[]{FestiveAffix.fmt(100.0f * this.getTrueLevel(rarity, 1.0f))});
        return comp.method_10852((class_2561)FestiveAffix.valueBounds((class_2561)minComp, (class_2561)maxComp));
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return cat.isLightWeapon() && this.values.containsKey(rarity);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public void markEquipment(class_1309 entity, class_1282 source) {
        if (entity instanceof class_1657 || ((BooleanComponent)ZenithComponents.NO_PINATA.get((Object)entity)).getValue()) {
            return;
        }
        entity.method_5743().forEach(i -> {
            if (!i.method_7960()) {
                i.method_7948().method_10556(MARKER, true);
            }
        });
    }

    public void drops(class_1309 target, class_1282 source, Collection<class_1542> drops) {
        if (target instanceof class_1657 || ((BooleanComponent)ZenithComponents.NO_PINATA.get((Object)target)).getValue()) {
            return;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            AffixInstance inst;
            class_1657 player = (class_1657)class_12972;
            if (!drops.isEmpty() && (inst = AffixHelper.getAffixes(player.method_6047()).get(Adventure.Affixes.FESTIVE)) != null && inst.isValid() && player.method_37908().field_9229.method_43057() < this.getTrueLevel((LootRarity)inst.rarity().get(), inst.level())) {
                if (Apotheosis.enableDebug) {
                    AdventureModule.LOGGER.info("Drops PRE loot pinata: {}", drops);
                }
                player.method_37908().method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
                ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11221, target.method_23317(), target.method_23318(), target.method_23321(), 2, 1.0, 0.0, 0.0, 0.0);
                ArrayList<class_1542> dropsList = new ArrayList<class_1542>(drops);
                for (class_1542 item : dropsList) {
                    if (item.method_6983().method_7985() && item.method_6983().method_7948().method_10545(MARKER)) continue;
                    for (int i = 0; i < 20; ++i) {
                        drops.add(new class_1542(player.method_37908(), item.method_23317(), item.method_23318(), item.method_23321(), item.method_6983().method_7972()));
                    }
                }
                for (class_1542 item : drops) {
                    if (item.method_6983().method_7909().method_7846()) continue;
                    item.method_5814(target.method_23317(), target.method_23318(), target.method_23321());
                    item.method_18800(-0.3 + target.method_37908().field_9229.method_43058() * 0.6, 0.3 + target.method_37908().field_9229.method_43058() * 0.3, -0.3 + target.method_37908().field_9229.method_43058() * 0.6);
                }
                if (Apotheosis.enableDebug && !drops.isEmpty()) {
                    AdventureModule.LOGGER.info("Drops POST loot pinata: {}", drops);
                }
            }
        }
    }

    public void removeMarker(Collection<class_1542> drops) {
        drops.forEach(ent -> {
            class_1799 s = ent.method_6983();
            if (s.method_7985() && s.method_7948().method_10545(MARKER)) {
                s.method_7969().method_10551(MARKER);
                if (s.method_7969().method_33133()) {
                    s.method_7980(null);
                }
            }
            ent.method_6979(s);
        });
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

