/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.attributeslib.components.BooleanComponent;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class SpectralShotAffix
extends Affix {
    public static final Codec<SpectralShotAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, SpectralShotAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public SpectralShotAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return cat.isRanged() && this.values.containsKey(rarity);
    }

    @Override
    public class_5250 getDescription(class_1799 stack, LootRarity rarity, float level) {
        return class_2561.method_43469((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{SpectralShotAffix.fmt(100.0f * this.getTrueLevel(rarity, level))});
    }

    @Override
    public class_2561 getAugmentingText(class_1799 stack, LootRarity rarity, float level) {
        class_5250 comp = this.getDescription(stack, rarity, level);
        class_5250 minComp = class_2561.method_43469((String)"%s%%", (Object[])new Object[]{SpectralShotAffix.fmt(100.0f * this.getTrueLevel(rarity, 0.0f))});
        class_5250 maxComp = class_2561.method_43469((String)"%s%%", (Object[])new Object[]{SpectralShotAffix.fmt(100.0f * this.getTrueLevel(rarity, 1.0f))});
        return comp.method_10852((class_2561)SpectralShotAffix.valueBounds((class_2561)minComp, (class_2561)maxComp));
    }

    @Override
    public void onArrowFired(class_1799 stack, LootRarity rarity, float level, class_1309 user, class_1665 arrow) {
        if (user.method_37908().field_9229.method_43057() <= this.getTrueLevel(rarity, level) && !user.method_37908().field_9236) {
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("onArrowFired spectral shot");
            }
            class_1744 arrowitem = (class_1744)class_1802.field_8236;
            class_1665 spectralArrow = arrowitem.method_7702(user.method_37908(), class_1799.field_8037, user);
            spectralArrow.method_7485((double)user.method_36455(), (double)user.method_36454(), 0.0, 2.0f, 1.0f);
            this.cloneMotion(arrow, spectralArrow);
            spectralArrow.method_7439(arrow.method_7443());
            spectralArrow.method_7438(arrow.method_7448());
            spectralArrow.method_7449(arrow.method_35207());
            spectralArrow.method_20803(arrow.method_20802());
            spectralArrow.field_7572 = class_1665.class_1666.field_7594;
            ((BooleanComponent)ZenithComponents.GENERATED_ARROW.get((Object)spectralArrow)).setValue(true);
            boolean didjoin = arrow.method_37908().method_8649((class_1297)spectralArrow);
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("did arrow join level: {}", (Object)didjoin);
            }
        }
    }

    private void cloneMotion(class_1665 src, class_1665 dest) {
        dest.method_18799(src.method_18798().method_1021(1.0));
        dest.method_36456(src.method_36454());
        dest.method_36457(src.method_36455());
        dest.field_5982 = dest.field_5982;
        dest.field_6004 = dest.field_6004;
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

