/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.salvaging;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.adventure.client.GrayBufferSource;
import dev.shadowsoffire.apotheosis.adventure.client.SimpleTexButton;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_811;

public class SalvagingScreen
extends AdventureContainerScreen<SalvagingMenu> {
    public static final class_2561 TITLE = class_2561.method_43471((String)"container.zenith.salvage");
    public static final class_2960 TEXTURE = new class_2960("zenith", "textures/gui/salvage.png");
    protected List<SalvagingRecipe.OutputData> results = new ArrayList<SalvagingRecipe.OutputData>();
    protected SimpleTexButton salvageBtn;

    public SalvagingScreen(SalvagingMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, TITLE);
        ((SalvagingMenu)this.field_2797).addSlotListener((id, stack) -> this.computeResults());
        this.field_2779 = 174;
    }

    protected void method_25426() {
        super.method_25426();
        int left = this.field_2776;
        int top = this.field_2800;
        this.salvageBtn = (SimpleTexButton)this.method_37063((class_364)new SimpleTexButton(left + 98, top + 34, 18, 18, 238, 0, TEXTURE, 256, 256, btn -> this.field_22787.field_1761.method_2900(((SalvagingMenu)this.field_2797).field_7763, 0), (class_2561)class_2561.method_43471((String)"button.zenith.salvage")).setInactiveMessage((class_2561)class_2561.method_43471((String)"button.zenith.no_salvage").method_27692(class_124.field_1061)));
        this.computeResults();
    }

    public void computeResults() {
        if (this.salvageBtn == null) {
            return;
        }
        ArrayList<SalvagingRecipe.OutputData> matches = new ArrayList<SalvagingRecipe.OutputData>();
        for (int i = 0; i < 15; ++i) {
            class_1735 s = ((SalvagingMenu)this.field_2797).method_7611(i);
            class_1799 stack = s.method_7677();
            SalvagingRecipe recipe = SalvagingMenu.findMatch((class_1937)class_310.method_1551().field_1687, stack);
            if (recipe == null) continue;
            for (SalvagingRecipe.OutputData d : recipe.getOutputs()) {
                int[] counts = SalvagingMenu.getSalvageCounts(d, stack);
                matches.add(new SalvagingRecipe.OutputData(d.stack, counts[0], counts[1]));
            }
        }
        ArrayList<SalvagingRecipe.OutputData> compressed = new ArrayList<SalvagingRecipe.OutputData>();
        for (SalvagingRecipe.OutputData data : matches) {
            if (data == null) continue;
            boolean success = false;
            for (SalvagingRecipe.OutputData existing : compressed) {
                if (!class_1799.method_31577((class_1799)data.stack, (class_1799)existing.stack)) continue;
                existing.min += data.min;
                existing.max += data.max;
                success = true;
                break;
            }
            if (success) continue;
            compressed.add(data);
        }
        this.results = compressed;
        this.salvageBtn.field_22763 = !this.results.isEmpty();
    }

    public void method_25394(class_332 gfx, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(gfx);
        super.method_25394(gfx, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        int maxDisplay = Math.min(6, this.results.size());
        IntOpenHashSet skipSlots = new IntOpenHashSet();
        for (int i = 0; i < maxDisplay; ++i) {
            class_1799 display = this.results.get((int)i).stack;
            int displaySlot = -1;
            for (int slot = 12; slot < 18; ++slot) {
                if (skipSlots.contains(slot)) continue;
                class_1799 outStack = ((class_1735)((SalvagingMenu)this.field_2797).field_7761.get(slot)).method_7677();
                if (outStack.method_7960()) {
                    displaySlot = slot;
                    skipSlots.add(slot);
                    break;
                }
                if (outStack.method_31574(display.method_7909())) break;
            }
            if (displaySlot == -1) continue;
            class_1735 slot = ((SalvagingMenu)this.field_2797).method_7611(displaySlot);
            SalvagingScreen.renderGuiItem(gfx, display, this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872, GrayBufferSource::new);
        }
        this.method_2380(gfx, pMouseX, pMouseY);
    }

    public static void renderGuiItem(class_332 gfx, class_1799 pStack, int pX, int pY, Function<class_4597, class_4597> wrapper) {
        boolean flag;
        class_310.method_1551().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 posestack = gfx.method_51448();
        posestack.method_22903();
        posestack.method_46416((float)pX, (float)pY, 100.0f);
        posestack.method_22904(8.0, 8.0, 0.0);
        posestack.method_22905(1.0f, -1.0f, 1.0f);
        posestack.method_22905(16.0f, 16.0f, 16.0f);
        class_310 mc = class_310.method_1551();
        class_1087 model = mc.method_1480().method_4019(pStack, (class_1937)mc.field_1687, (class_1309)mc.field_1724, pX ^ pY);
        boolean bl = flag = !model.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        class_310.method_1551().method_1480().method_23179(pStack, class_811.field_4317, false, posestack, wrapper.apply((class_4597)buffer), 0xF000F0, class_4608.field_21444, model);
        buffer.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        posestack.method_22909();
    }

    protected void method_2389(class_332 gfx, float pPartialTick, int pX, int pY) {
        gfx.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
    }

    protected void method_2380(class_332 gfx, int x, int y) {
        class_4587 stack = gfx.method_51448();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, -100.0f);
        ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
        tooltip.add(class_2561.method_43471((String)"text.zenith.salvage_results").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        for (SalvagingRecipe.OutputData data : this.results) {
            tooltip.add(class_2561.method_43469((String)"%s-%s %s", (Object[])new Object[]{data.min, data.max, data.stack.method_7964()}));
        }
        if (tooltip.size() > 1) {
            this.drawOnLeft(gfx, tooltip, this.field_2800 + 29);
        }
        stack.method_22909();
        super.method_2380(gfx, x, y);
    }
}

