/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.boss;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothMiniboss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.boss.MinibossRegistry;
import dev.shadowsoffire.apotheosis.adventure.client.BossSpawnMessage;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.cca.BossComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1917;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5251;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5894;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BossEvents {
    public static BossEvents INSTANCE = new BossEvents();
    public Object2IntMap<class_2960> bossCooldowns = new Object2IntOpenHashMap();

    public void init() {
        if (FabricLoader.getInstance().isModLoaded("architectury")) {
            EntityEvent.LIVING_CHECK_SPAWN.register((entity, world, x, y, z, type, spawner) -> {
                this.naturalBosses(entity, world, x, y, z, spawner, type);
                this.minibosses(entity, world, x, y, z, spawner, type);
                this.delayedMinibosses(entity, world, x, y, z, spawner, type);
                return EventResult.pass();
            });
        } else {
            LivingEntityEvents.CHECK_SPAWN.register(this::naturalBosses);
            LivingEntityEvents.CHECK_SPAWN.register(this::minibosses);
            LivingEntityEvents.CHECK_SPAWN.register(this::delayedMinibosses);
        }
        this.load();
        this.tick();
    }

    public boolean naturalBosses(class_1309 mob, class_1936 level, double x, double y, double z, @Nullable class_1917 spawner, class_3730 type) {
        if (type == class_3730.field_16459 || type == class_3730.field_16472) {
            class_5819 rand = level.method_8409();
            if (this.bossCooldowns.getInt((Object)mob.method_37908().method_27983().method_29177()) <= 0 && !level.method_8608() && mob instanceof class_1588) {
                class_5425 sLevel = (class_5425)level;
                Pair<Float, BossSpawnRules> rules = AdventureConfig.BOSS_SPAWN_RULES.get(sLevel.method_8410().method_27983().method_29177());
                if (rules == null) {
                    if (Apotheosis.enableDebug) {
                        AdventureModule.LOGGER.info("Boss spawn rules are null");
                    }
                    return true;
                }
                if (rand.method_43057() <= ((Float)rules.getLeft()).floatValue() && ((BossSpawnRules)rules.getRight()).test(sLevel, class_2338.method_49637((double)x, (double)y, (double)z))) {
                    class_1657 player = sLevel.method_18459(x, y, z, -1.0, false);
                    if (player == null) {
                        if (Apotheosis.enableDebug) {
                            AdventureModule.LOGGER.info("No player context for boss spawn");
                        }
                        return true;
                    }
                    ApothBoss item = (ApothBoss)BossRegistry.INSTANCE.getRandomItem(rand, player.method_7292(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((class_1937)sLevel.method_8410()), GameStagesCompat.IStaged.matches(player)});
                    class_1308 boss = item.createBoss(sLevel, class_2338.method_49637((double)(x - 0.5), (double)y, (double)(z - 0.5)), rand, player.method_7292());
                    if (AdventureConfig.bossAutoAggro && !player.method_7337()) {
                        boss.method_5980((class_1309)player);
                    }
                    if (this.canSpawn((class_1936)sLevel, boss, player.method_5858((class_1297)boss))) {
                        sLevel.method_30771((class_1297)boss);
                        AdventureModule.debugLog(boss.method_24515(), "Surface Boss - " + boss.method_5477().getString());
                        class_2561 name = this.getName(boss);
                        if (name == null || name.method_10866().method_10973() == null) {
                            AdventureModule.LOGGER.warn("A Boss {} ({}) has spawned without a custom name!", (Object)boss.method_5477().getString(), (Object)class_1299.method_5890((class_1299)boss.method_5864()));
                        } else {
                            sLevel.method_18456().forEach(p -> {
                                if (!(p instanceof class_3222)) {
                                    return;
                                }
                                class_243 tPos = new class_243(boss.method_23317(), AdventureConfig.bossAnnounceIgnoreY ? p.method_23318() : boss.method_23318(), boss.method_23321());
                                if (p.method_5707(tPos) <= (double)(AdventureConfig.bossAnnounceRange * AdventureConfig.bossAnnounceRange)) {
                                    ((class_3222)p).field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"info.zenith.boss_spawn", (Object[])new Object[]{name, (int)boss.method_23317(), (int)boss.method_23318()})));
                                    class_5251 color = name.method_10866().method_10973();
                                    if (Apotheosis.enableDebug) {
                                        AdventureModule.LOGGER.warn("Boss spawn position: {}", (Object)boss.method_24515());
                                    }
                                    if (p.method_5682() != null) {
                                        BossSpawnMessage.sendTo((class_3222)p, new BossSpawnMessage(boss.method_24515(), color == null ? 0xFFFFFF : color.method_27716()));
                                    }
                                }
                            });
                        }
                        this.bossCooldowns.put((Object)mob.method_37908().method_27983().method_29177(), AdventureConfig.bossSpawnCooldown);
                        return true;
                    }
                }
            } else if (!level.method_8608() && mob instanceof class_1588 && Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("Boss cooldown is too high to spawn a mob, currently {}", (Object)this.bossCooldowns.getInt((Object)mob.method_37908().method_27983().method_29177()));
            }
        } else if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Current boss cooldown {}", (Object)this.bossCooldowns.getInt((Object)mob.method_37908().method_27983().method_29177()));
        }
        return true;
    }

    @Nullable
    private class_2561 getName(class_1308 boss) {
        return boss.method_24204().filter(e -> ((BossComponent)ZenithComponents.BOSS_DATA.get(e)).getIsBoss()).findFirst().map(class_1297::method_5797).orElse(null);
    }

    public boolean minibosses(class_1309 entity, class_1936 level, double x, double y, double z, @Nullable class_1917 spawner, class_3730 type) {
        class_5819 rand = level.method_8409();
        if (!level.method_8608() && entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            class_5425 sLevel = (class_5425)level;
            class_1657 player = sLevel.method_18459(x, y, z, -1.0, false);
            if (player == null) {
                return false;
            }
            ApothMiniboss item = (ApothMiniboss)MinibossRegistry.INSTANCE.getRandomItem(rand, player.method_7292(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((class_1937)sLevel.method_8410()), GameStagesCompat.IStaged.matches(player), MinibossRegistry.IEntityMatch.matches((class_1297)mob)});
            if (item != null && !item.isExcluded(mob, sLevel, type) && sLevel.method_8409().method_43057() <= item.getChance()) {
                ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).setMiniBoss(MinibossRegistry.INSTANCE.getKey(item).toString());
                ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).setMinibossLuck(player.method_7292());
                AdventureModule.debugLog(mob.method_24515(), "Miniboss - " + mob.method_5477().getString());
                if (!item.shouldFinalize()) {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean delayedMinibosses(class_1309 living, class_1936 level, double x, double y, double z, @Nullable class_1917 spawner, class_3730 type) {
        if (!level.method_8608() && living instanceof class_1308) {
            ApothMiniboss item;
            String key;
            class_1308 mob = (class_1308)living;
            if (mob.getCustomData().method_10545("apoth.miniboss")) {
                ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).setMiniBoss(mob.getCustomData().method_10558("apoth.miniboss"));
                mob.getCustomData().method_10551("apoth.miniboss");
            }
            if ((key = ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).getMiniBoss()) != null && (item = (ApothMiniboss)MinibossRegistry.INSTANCE.getValue(new class_2960(key))) != null) {
                if (mob.getCustomData().method_10545("apoth.miniboss.luck")) {
                    ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).setMinibossLuck(mob.getCustomData().method_10583("apoth.miniboss.luck"));
                    mob.getCustomData().method_10551("apoth.miniboss.luck");
                }
                item.transformMiniboss((class_5425)((class_3218)level), mob, level.method_8409(), ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)mob)).getMinibossLuck());
            }
        }
        return true;
    }

    public void tick() {
        ServerTickEvents.END_WORLD_TICK.register(world -> this.bossCooldowns.computeIntIfPresent((Object)world.method_27983().method_29177(), (key, value) -> Math.max(0, value - 1)));
    }

    public void load() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> server.method_3847(class_1937.field_25179).method_17983().method_17924(this::loadTimes, () -> new TimerPersistData(), "zenith_boss_times"));
    }

    private TimerPersistData loadTimes(class_2487 tag) {
        this.bossCooldowns.clear();
        for (String s : tag.method_10541()) {
            class_2960 id = new class_2960(s);
            int val = tag.method_10550(s);
            this.bossCooldowns.put((Object)id, val);
        }
        return new TimerPersistData();
    }

    private boolean canSpawn(class_1936 world, class_1308 entity, double playerDist) {
        if (playerDist > (double)(entity.method_5864().method_5891().method_27919() * entity.method_5864().method_5891().method_27919()) && entity.method_5974(playerDist)) {
            return false;
        }
        return entity.method_5979(world, class_3730.field_16459) && entity.method_5957((class_4538)world);
    }

    public static enum BossSpawnRules implements BiPredicate<class_5425, class_2338>
    {
        NEEDS_SKY(class_1920::method_8311),
        NEEDS_SURFACE((level, pos) -> pos.method_10264() >= level.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260())),
        BELOW_SURFACE((level, pos) -> pos.method_10264() < level.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260())),
        CANNOT_SEE_SKY((level, pos) -> !level.method_8311(pos)),
        SURFACE_OUTER_END((level, pos) -> NEEDS_SURFACE.test((class_5425)level, (class_2338)pos) && (class_3532.method_15382((int)pos.method_10263()) > 1024 || class_3532.method_15382((int)pos.method_10260()) > 1024)),
        ANY((level, pos) -> true);

        public static final Codec<BossSpawnRules> CODEC;
        BiPredicate<class_5425, class_2338> pred;

        private BossSpawnRules(BiPredicate<class_5425, class_2338> pred) {
            this.pred = pred;
        }

        @Override
        public boolean test(class_5425 t, class_2338 u) {
            return this.pred.test(t, u);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(BossSpawnRules.class);
        }
    }

    private class TimerPersistData
    extends class_18 {
        private TimerPersistData() {
        }

        public class_2487 method_75(class_2487 tag) {
            for (Object2IntMap.Entry e : BossEvents.this.bossCooldowns.object2IntEntrySet()) {
                tag.method_10569(((class_2960)e.getKey()).toString(), e.getIntValue());
            }
            return tag;
        }
    }
}

