/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.client;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

public abstract class DropDownList<T>
extends class_339 {
    public static final int NO_SELECTION = -1;
    protected final int maxDisplayedEntries;
    protected final int baseHeight;
    protected List<T> entries;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected boolean isOpen = false;
    protected int selected = -1;

    public DropDownList(int x, int y, int width, int height, class_2561 narrationMsg, List<T> entries, int maxDisplayedEntries) {
        super(x, y, width, height, narrationMsg);
        this.entries = entries;
        this.maxDisplayedEntries = maxDisplayedEntries;
        this.baseHeight = height;
    }

    protected void method_48579(class_332 gfx, int mouseX, int mouseY, float partialTick) {
        int selected = this.getSelected();
        if (selected != -1) {
            this.renderEntry(gfx, this.method_46426(), this.method_46427(), mouseX, mouseY, this.entries.get(selected));
        }
        if (this.isOpen) {
            for (int i = this.startIndex; i < this.startIndex + this.maxDisplayedEntries && i < this.entries.size(); ++i) {
                this.renderEntry(gfx, this.method_46426(), this.method_46427() + this.baseHeight * (1 + i - this.startIndex), mouseX, mouseY, this.entries.get(i));
            }
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        if (!this.isOpen) {
            if (this.entries.isEmpty()) {
                return;
            }
            this.isOpen = true;
            this.field_22759 = this.baseHeight * (1 + Math.min(this.entries.size(), this.maxDisplayedEntries));
        } else {
            this.selected = this.getHoveredSlot(mouseX, mouseY);
            this.field_22759 = this.baseHeight;
            this.isOpen = false;
        }
    }

    public static boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public int getHoveredSlot(double mouseX, double mouseY) {
        if (DropDownList.isHovering(this.method_46426(), this.method_46427(), this.field_22758, this.baseHeight, mouseX, mouseY)) {
            return this.getSelected();
        }
        if (this.isOpen) {
            for (int i = 0; i < this.maxDisplayedEntries; ++i) {
                if (this.startIndex + i >= this.entries.size() || !DropDownList.isHovering(this.method_46426(), this.method_46427() + (i + 1) * this.baseHeight, this.field_22758, this.baseHeight, mouseX, mouseY)) continue;
                return this.startIndex + i;
            }
        }
        return -1;
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int barTop = this.method_46426() + 14;
            int barBot = barTop + 103;
            this.scrollOffs = ((float)pMouseY - (float)barTop - 6.0f) / ((float)(barBot - barTop) - 12.0f) - 0.12f;
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.isOpen() && this.entries.size() > this.maxDisplayedEntries;
    }

    protected int getOffscreenRows() {
        return this.entries.size() - this.maxDisplayedEntries;
    }

    public int getSelected() {
        return class_3532.method_15340((int)this.selected, (int)-1, (int)(this.entries.size() - 1));
    }

    public void setSelected(int selected) {
        this.selected = class_3532.method_15340((int)selected, (int)-1, (int)(this.entries.size() - 1));
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected abstract void renderEntry(class_332 var1, int var2, int var3, int var4, int var5, T var6);

    protected void method_47399(class_6382 output) {
    }

    public void setEntries(List<T> entries) {
        this.entries = entries;
        this.selected = this.entries.isEmpty() ? -1 : 0;
        this.field_22759 = this.baseHeight;
        this.startIndex = 0;
        this.isOpen = false;
    }
}

