/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class AffixCommand {
    public static final SuggestionProvider<class_2168> SUGGEST_AFFIX = (ctx, builder) -> class_2172.method_9264(AffixRegistry.INSTANCE.getKeys().stream().map(class_2960::toString), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<class_2168> SUGGEST_APPLICABLE_AFFIX = (ctx, builder) -> {
        class_1309 living;
        class_1799 held;
        class_1297 entity = ((class_2168)ctx.getSource()).method_9228();
        if (entity instanceof class_1309 && !(held = (living = (class_1309)entity).method_6047()).method_7960()) {
            LootCategory cat = LootCategory.forItem(held);
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!cat.isNone() && rarity.isBound()) {
                Stream<String> suggestions = AffixRegistry.INSTANCE.getValues().stream().filter(a -> a.canApplyTo(held, cat, (LootRarity)rarity.get())).map(arg_0 -> ((AffixRegistry)AffixRegistry.INSTANCE).getKey(arg_0)).map(class_2960::toString);
                return class_2172.method_9264(suggestions, (SuggestionsBuilder)builder);
            }
        }
        return class_2172.method_9265(Collections.emptyList(), (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<class_2168> SUGGEST_AFFIX_ON_ITEM = (ctx, builder) -> {
        class_1309 living;
        class_1799 held;
        class_1297 entity = ((class_2168)ctx.getSource()).method_9228();
        if (entity instanceof class_1309 && !(held = (living = (class_1309)entity).method_6047()).method_7960()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            return class_2172.method_9264(affixes.keySet().stream().map(DynamicHolder::getId).map(class_2960::toString), (SuggestionsBuilder)builder);
        }
        return class_2172.method_9265(Collections.emptyList(), (SuggestionsBuilder)builder);
    };

    public static void register(LiteralArgumentBuilder<class_2168> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"affix").requires(c -> c.method_9259(2));
        builder.then(class_2170.method_9247((String)"apply").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"affix", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_APPLICABLE_AFFIX).then(class_2170.method_9244((String)"level", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(c -> AffixCommand.applyAffix((CommandContext<class_2168>)c, class_2232.method_9443((CommandContext)c, (String)"affix"), FloatArgumentType.getFloat((CommandContext)c, (String)"level"))))).executes(c -> AffixCommand.applyAffix((CommandContext<class_2168>)c, class_2232.method_9443((CommandContext)c, (String)"affix"), ((class_2168)c.getSource()).method_9225().field_9229.method_43057()))));
        builder.then(class_2170.method_9247((String)"list").executes(AffixCommand::listAffixes));
        builder.then(class_2170.method_9247((String)"list_alternatives").then(class_2170.method_9244((String)"affix", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_AFFIX_ON_ITEM).executes(c -> AffixCommand.listAlternatives((CommandContext<class_2168>)c, class_2232.method_9443((CommandContext)c, (String)"affix")))));
        root.then((ArgumentBuilder)builder);
    }

    public static int applyAffix(CommandContext<class_2168> c, class_2960 affixId, float level) {
        DynamicHolder afx = AffixRegistry.INSTANCE.holder(affixId);
        if (!afx.isBound()) {
            return AffixCommand.fail(c, "Unknown affix: " + affixId, -1);
        }
        class_1297 entity = ((class_2168)c.getSource()).method_9228();
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            class_1799 held = living.method_6047();
            if (held.method_7960()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            LootCategory cat = LootCategory.forItem(held);
            if (cat.isNone()) {
                return AffixCommand.fail(c, "The target item must have a valid loot category", -4);
            }
            if (!((Affix)afx.get()).canApplyTo(held, cat, (LootRarity)rarity.get())) {
                return AffixCommand.fail(c, "The selected affix cannot be applied to the target item.", -5);
            }
            AffixHelper.applyAffix(held, new AffixInstance((DynamicHolder<? extends Affix>)afx, held, rarity, level));
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43469((String)"Successfully applied affix %s with level %s to %s", (Object[])new Object[]{affixId, Float.valueOf(level), held.method_7954()}), true);
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int listAffixes(CommandContext<class_2168> c) {
        class_1297 entity = ((class_2168)c.getSource()).method_9228();
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            class_1799 held = living.method_6047();
            if (held.method_7960()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            ((class_2168)c.getSource()).method_45068((class_2561)class_2561.method_43469((String)"Affixes present on %s:", (Object[])new Object[]{held.method_7954()}));
            affixes.forEach((afx, inst) -> {
                class_5250 name = class_2561.method_43469((String)"[%s]", (Object[])new Object[]{inst.getName(true)});
                name.method_10862(class_2583.field_24360.method_10977(class_124.field_1054).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)inst.getAugmentingText())));
                ((class_2168)c.getSource()).method_45068((class_2561)class_2561.method_43469((String)"%s - %s%%", (Object[])new Object[]{name, Affix.fmt(100.0f * inst.level())}));
            });
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int listAlternatives(CommandContext<class_2168> c, class_2960 affixId) {
        DynamicHolder afx = AffixRegistry.INSTANCE.holder(affixId);
        if (!afx.isBound()) {
            return AffixCommand.fail(c, "Unknown affix: " + affixId, -1);
        }
        class_1297 entity = ((class_2168)c.getSource()).method_9228();
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            class_1799 held = living.method_6047();
            if (held.method_7960()) {
                return AffixCommand.fail(c, "The target entity must have an item in their main hand.", -2);
            }
            DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(held);
            if (!rarity.isBound()) {
                return AffixCommand.fail(c, "The target item must have a set rarity.", -3);
            }
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(held);
            if (!affixes.containsKey(afx)) {
                return AffixCommand.fail(c, "The target item does not contain the selected affix.", -4);
            }
            List<DynamicHolder<? extends Affix>> alternatives = LootController.getAvailableAffixes(held, (LootRarity)rarity.get(), affixes.keySet(), ((Affix)afx.get()).getType());
            ((class_2168)c.getSource()).method_45068((class_2561)class_2561.method_43469((String)"Possible alternatives to %s:", (Object[])new Object[]{((Affix)afx.get()).getName(true)}));
            alternatives.forEach(a -> {
                class_5250 name = class_2561.method_43469((String)"[%s]", (Object[])new Object[]{((Affix)a.get()).getName(true)});
                class_2561 augTxt = ((Affix)a.get()).getAugmentingText(held, (LootRarity)rarity.get(), 0.5f);
                name.method_10862(class_2583.field_24360.method_10977(class_124.field_1054).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)augTxt)));
                ((class_2168)c.getSource()).method_45068((class_2561)AttributeHelper.list().method_10852((class_2561)name));
            });
            return 0;
        }
        return AffixCommand.fail(c, "/apoth affix must be executed by a living entity.", -10);
    }

    public static int fail(CommandContext<class_2168> c, String msg, int code) {
        ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43471((String)msg));
        return code;
    }
}

