/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket;

import com.google.common.collect.ImmutableList;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.event.GetItemSocketsEvent;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class SocketHelper {
    public static final class_2960 GEMS_CACHED_OBJECT = Apotheosis.loc("gems");
    public static final String AFFIX_DATA = "affix_data";
    public static final String GEMS = "gems";
    public static final String SOCKETS = "sockets";

    public static int getSockets(class_1799 stack) {
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        int sockets = afxData != null ? afxData.method_10550(SOCKETS) : 0;
        GetItemSocketsEvent event = new GetItemSocketsEvent(stack, sockets);
        GetItemSocketsEvent.GET_ITEM_SOCKETS.invoker();
        return event.getSockets();
    }

    public static void setSockets(class_1799 stack, int sockets) {
        stack.method_7911(AFFIX_DATA).method_10569(SOCKETS, sockets);
    }

    public static SocketedGems getGems(class_1799 stack) {
        return (SocketedGems)CachedObject.CachedObjectSource.getOrCreate((class_1799)stack, (class_2960)GEMS_CACHED_OBJECT, SocketHelper::getGemsImpl, SocketHelper::hashSockets);
    }

    private static int hashSockets(class_1799 stack) {
        return Objects.hash(stack.method_7941(AFFIX_DATA), SocketHelper.getSockets(stack));
    }

    private static SocketedGems getGemsImpl(class_1799 stack) {
        int size = SocketHelper.getSockets(stack);
        if (size <= 0 || stack.method_7960()) {
            return SocketedGems.EMPTY;
        }
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return SocketedGems.EMPTY;
        }
        class_2371 gems = class_2371.method_10213((int)size, (Object)GemInstance.EMPTY);
        int i = 0;
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        if (afxData != null && afxData.method_10545(GEMS)) {
            class_2499 gemData = afxData.method_10554(GEMS, 10);
            for (class_2520 tag : gemData) {
                class_1799 gemStack = class_1799.method_7915((class_2487)((class_2487)tag));
                gemStack.method_7939(1);
                GemInstance inst = GemInstance.socketed(stack, gemStack);
                if (inst.isValid()) {
                    gems.set(i++, inst);
                }
                if (i < size) continue;
                break;
            }
        }
        return new SocketedGems((ImmutableList<GemInstance>)ImmutableList.copyOf((Collection)gems));
    }

    public static void setGems(class_1799 stack, SocketedGems gems) {
        class_2487 afxData = stack.method_7911(AFFIX_DATA);
        class_2499 gemData = new class_2499();
        for (GemInstance inst : gems) {
            gemData.add((Object)inst.gemStack().method_7953(new class_2487()));
        }
        afxData.method_10566(GEMS, (class_2520)gemData);
    }

    public static boolean hasEmptySockets(class_1799 stack) {
        return SocketHelper.getGems(stack).gems().stream().anyMatch(g -> !g.isValid());
    }

    public static int getFirstEmptySocket(class_1799 stack) {
        SocketedGems gems = SocketHelper.getGems(stack);
        for (int socket = 0; socket < gems.size(); ++socket) {
            if (gems.get(socket).isValid()) continue;
            return socket;
        }
        return 0;
    }

    private static List<class_1799> getGems(class_1665 arrow) {
        int sockets;
        class_2487 afxData = arrow.getCustomData().method_10562(AFFIX_DATA);
        int n = sockets = afxData != null ? afxData.method_10550(SOCKETS) : 0;
        if (sockets <= 0) {
            return Collections.emptyList();
        }
        class_2371 gems = class_2371.method_10213((int)sockets, (Object)class_1799.field_8037);
        int i = 0;
        if (afxData != null && afxData.method_10545(GEMS)) {
            class_2499 gemData = afxData.method_10554(GEMS, 10);
            for (class_2520 tag : gemData) {
                class_1799 gemStack = class_1799.method_7915((class_2487)((class_2487)tag));
                gemStack.method_7939(1);
                if (GemInstance.unsocketed(gemStack).isValidUnsocketed()) {
                    gems.set(i++, gemStack);
                }
                if (i < sockets) continue;
                break;
            }
        }
        return gems;
    }

    public static Stream<GemInstance> getGemInstances(class_1665 arrow) {
        LootCategory cat = AffixHelper.getShooterCategory((class_1297)arrow);
        if (cat == null) {
            return Stream.empty();
        }
        return SocketHelper.getGems(arrow).stream().map(gemStack -> GemInstance.socketed(cat, gemStack)).filter(GemInstance::isValid);
    }
}

