/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import org.jetbrains.annotations.Nullable;

public record SocketedGems(ImmutableList<GemInstance> gems) implements List<GemInstance>
{
    public static final SocketedGems EMPTY = new SocketedGems((ImmutableList<GemInstance>)ImmutableList.of());

    public SocketedGems(List<GemInstance> gems) {
        this((ImmutableList<GemInstance>)ImmutableList.copyOf(gems));
    }

    public void addModifiers(LootCategory cat, class_1304 type, BiConsumer<class_1320, class_1322> map) {
        this.streamValidGems().forEach(inst -> inst.addModifiers(type, map));
    }

    public int getDamageProtection(class_1282 source) {
        return this.streamValidGems().map(inst -> inst.getDamageProtection(source)).reduce(0, Integer::sum);
    }

    public float getDamageBonus(class_1310 creatureType) {
        return this.streamValidGems().map(inst -> Float.valueOf(inst.getDamageBonus(creatureType))).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void doPostAttack(class_1309 user, class_1297 target) {
        this.streamValidGems().forEach(inst -> {
            int old = target.field_6008;
            target.field_6008 = 0;
            inst.doPostAttack(user, target);
            target.field_6008 = old;
        });
    }

    public void doPostHurt(class_1309 user, class_1297 attacker) {
        this.streamValidGems().forEach(inst -> inst.doPostHurt(user, attacker));
    }

    public void onArrowFired(class_1309 user, class_1665 arrow) {
        this.streamValidGems().forEach(inst -> inst.onArrowFired(user, arrow));
    }

    @Nullable
    public class_1269 onItemUse(class_1838 useinst) {
        return this.streamValidGems().map(inst -> inst.onItemUse(useinst)).filter((Predicate<class_1269>)Predicates.notNull()).findFirst().orElse(null);
    }

    public float onShieldBlock(class_1309 entity, class_1282 source, float amount) {
        for (GemInstance inst : this.gems) {
            if (!inst.isValid()) continue;
            amount = inst.onShieldBlock(entity, source, amount);
        }
        return amount;
    }

    public void onBlockBreak(class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        this.streamValidGems().forEach(inst -> inst.onBlockBreak(player, world, pos, state));
    }

    public DoubleStream getDurabilityBonusPercentage(class_3222 user) {
        return this.streamValidGems().mapToDouble(inst -> inst.getDurabilityBonusPercentage(user));
    }

    public float onHurt(class_1282 src, class_1309 ent, float amount) {
        for (GemInstance inst : this.gems) {
            if (!inst.isValid()) continue;
            amount = inst.onHurt(src, ent, amount);
        }
        return amount;
    }

    public void getEnchantmentLevels(Map<class_1887, Integer> enchantments) {
        this.streamValidGems().forEach(inst -> inst.getEnchantmentLevels(enchantments));
    }

    public void modifyLoot(ObjectArrayList<class_1799> loot, class_47 ctx) {
        this.streamValidGems().forEach(inst -> inst.modifyLoot(loot, ctx));
    }

    public Stream<GemInstance> streamValidGems() {
        return this.gems.stream().filter(GemInstance::isValid);
    }

    @Override
    public int size() {
        return this.gems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.gems.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.gems.contains(o);
    }

    @Override
    public Iterator<GemInstance> iterator() {
        return this.gems.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.gems.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.gems.toArray((Object[])a);
    }

    @Override
    @Deprecated
    public boolean add(GemInstance e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.gems.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends GemInstance> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends GemInstance> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GemInstance get(int index) {
        return (GemInstance)this.gems.get(index);
    }

    @Override
    @Deprecated
    public GemInstance set(int index, GemInstance element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void add(int index, GemInstance element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GemInstance remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.gems.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.gems.lastIndexOf(o);
    }

    @Override
    public ListIterator<GemInstance> listIterator() {
        return this.gems.listIterator();
    }

    @Override
    public ListIterator<GemInstance> listIterator(int index) {
        return this.gems.listIterator(index);
    }

    @Override
    public List<GemInstance> subList(int fromIndex, int toIndex) {
        return this.gems.subList(fromIndex, toIndex);
    }
}

