/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_5250;

public class LeechBlockBonus
extends GemBonus {
    public static Codec<LeechBlockBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, LeechBlockBonus::new));
    protected final Map<LootRarity, Data> values;

    public LeechBlockBonus(Map<LootRarity, Data> values) {
        super(Apotheosis.loc("leech_block"), new GemClass("shield", (Set<LootCategory>)ImmutableSet.of((Object)LootCategory.SHIELD)));
        this.values = values;
    }

    @Override
    public float onShieldBlock(class_1799 gem, LootRarity rarity, class_1309 entity, class_1282 source, float amount) {
        Data d = this.values.get(rarity);
        if (amount <= 2.0f || Affix.isOnCooldown(this.getId(), d.cooldown, entity)) {
            return amount;
        }
        entity.method_6025(amount * d.healFactor);
        Affix.startCooldown(this.getId(), entity);
        return amount;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        Data d = this.values.get(rarity);
        class_5250 cooldown = class_2561.method_43469((String)"affix.zenith.cooldown", (Object[])new Object[]{class_3544.method_15439((int)d.cooldown)});
        return class_2561.method_43469((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(d.healFactor * 100.0f), cooldown}).method_27692(class_124.field_1054);
    }

    @Override
    public LeechBlockBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    record Data(float healFactor, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("heal_factor").forGetter(Data::healFactor), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }
}

