/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawn;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.spawn.enchantment.CapturingEnchant;
import dev.shadowsoffire.apotheosis.spawn.modifiers.SpawnerModifier;
import dev.shadowsoffire.attributeslib.components.SyncedBooleanComponent;
import dev.shadowsoffire.placebo.config.Configuration;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2636;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerModule {
    public static final Logger LOG = LogManager.getLogger((String)"Zenith : Spawner");
    public static final class_3956<SpawnerModifier> MODIFIER = class_3956.method_17726((String)"zenith:spawner_modifier");
    public static int spawnerSilkLevel = 1;
    public static int spawnerSilkDamage = 100;
    public static Set<class_2960> bannedMobs = new HashSet<class_2960>();
    public static class_1887 CAPTURING = new CapturingEnchant();

    public static void init() {
        SpawnerModule.dropsEvent();
        SpawnerModule.handleUseItem();
        SpawnerModule.tickDumbMobs();
        SpawnerModule.dumbMobsCantTeleport();
        SpawnerModule.register();
        SpawnerModule.reload(false);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Apotheosis.loc("spawner_modifier"), (Object)SpawnerModifier.SERIALIZER);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)Apotheosis.loc("capturing"), (Object)CAPTURING);
    }

    public static void dropsEvent() {
        LivingEntityEvents.DROPS.register((target, source, drops, lootingLevel, recentlyHit) -> {
            if (drops == null) {
                return false;
            }
            CapturingEnchant.handleCapturing(target, source, drops);
            return false;
        });
    }

    public static void handleUseItem() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!player.method_7325() && world.method_8321(hitResult.method_17777()) instanceof class_2636) {
                class_1792 patt3144$temp;
                class_1799 s = player.method_5998(hand);
                if (Apotheosis.enableDebug) {
                    LOG.info("BlockEntity is spawner");
                }
                if ((patt3144$temp = s.method_7909()) instanceof class_1826) {
                    class_1299 type;
                    class_1826 egg = (class_1826)patt3144$temp;
                    if (Apotheosis.enableDebug) {
                        LOG.info("Item is spawn egg");
                    }
                    if (bannedMobs.contains(class_1299.method_5890((class_1299)(type = egg.method_8015(s.method_7969()))))) {
                        if (Apotheosis.enableDebug) {
                            LOG.info("Mob {} is banned from being added to spawners", (Object)class_1299.method_5890((class_1299)type));
                        }
                        return class_1269.field_21466;
                    }
                    if (Apotheosis.enableDebug) {
                        LOG.info("Added mob {} spawner.", (Object)class_1299.method_5890((class_1299)type));
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    public static void tickDumbMobs() {
        LivingEntityEvents.TICK.register(entity -> {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                if (mob.getCustomData().method_10545("zenith:movable")) {
                    ((SyncedBooleanComponent)ZenithComponents.MOVABLE.get((Object)mob)).setValue(mob.getCustomData().method_10577("zenith:movable"));
                    mob.getCustomData().method_10551("zenith:movable");
                }
                if (!mob.method_37908().field_9236 && mob.method_5987() && ((SyncedBooleanComponent)ZenithComponents.MOVABLE.get((Object)mob)).getValue()) {
                    mob.method_5977(false);
                    mob.method_6091(new class_243((double)mob.field_6212, (double)mob.field_6250, (double)mob.field_6227));
                    mob.method_5977(true);
                }
            }
        });
    }

    public static void dumbMobsCantTeleport() {
        EntityEvents.TELEPORT.register(e -> {
            if (((SyncedBooleanComponent)ZenithComponents.MOVABLE.get((Object)e.getEntity())).getValue()) {
                e.setCanceled(true);
            }
        });
    }

    public static void reload(boolean e) {
        String[] bans;
        Configuration config = new Configuration(new File(Apotheosis.configDir, "spawner.cfg"));
        config.setTitle("Zenith Spawner Module Configuration");
        spawnerSilkLevel = config.getInt("Spawner Silk Level", "general", 1, -1, 127, "The level of silk touch needed to harvest a spawner.  Set to -1 to disable, 0 to always drop.  The enchantment module can increase the max level of silk touch.\nFunctionally server-authoritative, but should match on client for information.");
        spawnerSilkDamage = config.getInt("Spawner Silk Damage", "general", 100, 0, 100000, "The durability damage dealt to an item that silk touches a spawner.\nServer-authoritative.");
        bannedMobs.clear();
        for (String s : bans = config.getStringList("Banned Mobs", "spawn_eggs", new String[0], "A list of entity registry names that cannot be applied to spawners via egg.\nShould match between client and server.")) {
            try {
                bannedMobs.add(new class_2960(s));
            }
            catch (class_151 ex) {
                LOG.error("Invalid entry {} detected in the spawner banned mobs list.", (Object)s);
                ex.printStackTrace();
            }
        }
        if (!e && config.hasChanged()) {
            config.save();
        }
    }

    public static class_2561 concat(Object ... args) {
        return class_2561.method_43469((String)"misc.zenith.value_concat", (Object[])new Object[]{args[0], class_2561.method_43470((String)args[1].toString()).method_27692(class_124.field_1080)}).method_27692(class_124.field_1060);
    }
}

