/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawn.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.spawn.SpawnerModule;
import dev.shadowsoffire.apotheosis.spawn.modifiers.StatModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2636;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class SpawnerModifier
implements class_1860<class_1263> {
    public static final Serializer SERIALIZER = new Serializer();
    protected final class_2960 id;
    protected final class_1856 mainHand;
    protected final class_1856 offHand;
    protected final boolean consumesOffhand;
    protected final List<StatModifier<?>> statChanges;

    public SpawnerModifier(class_2960 id, class_1856 mainHand, class_1856 offHand, boolean consumesOffhand, List<StatModifier<?>> stats) {
        this.id = id;
        this.mainHand = mainHand;
        this.offHand = offHand;
        this.consumesOffhand = consumesOffhand;
        this.statChanges = ImmutableList.copyOf(stats);
    }

    public boolean matches(class_2636 tile, class_1799 mainhand, class_1799 offhand) {
        if (this.mainHand.method_8093(mainhand)) {
            if (this.offHand == class_1856.field_9017) {
                return true;
            }
            return this.offHand.method_8093(offhand);
        }
        return false;
    }

    public boolean apply(class_2636 tile) {
        boolean success = false;
        for (StatModifier<?> m : this.statChanges) {
            if (!m.apply(tile)) continue;
            success = true;
            tile.method_5431();
        }
        return success;
    }

    public boolean consumesOffhand() {
        return this.consumesOffhand;
    }

    public class_1856 getMainhandInput() {
        return this.mainHand;
    }

    public class_1856 getOffhandInput() {
        return this.offHand;
    }

    public List<StatModifier<?>> getStatModifiers() {
        return this.statChanges;
    }

    @Deprecated
    public boolean method_8115(class_1263 pContainer, class_1937 pLevel) {
        return false;
    }

    @Deprecated
    public class_1799 method_8116(class_1263 pContainer, class_5455 regs) {
        return class_1799.field_8037;
    }

    @Deprecated
    public boolean method_8113(int pWidth, int pHeight) {
        return false;
    }

    @Deprecated
    public class_1799 method_8110(class_5455 regs) {
        return class_1799.field_8037;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpawnerModule.MODIFIER;
    }

    @Nullable
    public static SpawnerModifier findMatch(class_2636 tile, class_1799 mainhand, class_1799 offhand) {
        ArrayList recipes = new ArrayList(tile.method_10997().method_8433().method_30027(SpawnerModule.MODIFIER));
        recipes.sort((r1, r2) -> r1.offHand == class_1856.field_9017 ? (r2.offHand == class_1856.field_9017 ? 0 : 1) : -1);
        for (SpawnerModifier r : recipes) {
            if (!r.matches(tile, mainhand, offhand)) continue;
            return r;
        }
        return null;
    }

    public static class Serializer
    implements class_1865<SpawnerModifier> {
        public SpawnerModifier fromJson(class_2960 id, JsonObject obj) {
            class_1856 mainhand = class_1856.method_52177((JsonElement)obj.get("mainhand"));
            class_1856 offhand = obj.has("offhand") ? class_1856.method_52177((JsonElement)obj.get("offhand")) : class_1856.field_9017;
            JsonArray stats = obj.get("stat_changes").getAsJsonArray();
            ArrayList statChanges = new ArrayList();
            for (JsonElement e : stats) {
                statChanges.add(StatModifier.parse(e.getAsJsonObject()));
            }
            return new SpawnerModifier(id, mainhand, offhand, offhand == class_1856.field_9017 ? false : obj.get("consumes_offhand").getAsBoolean(), statChanges);
        }

        public SpawnerModifier fromNetwork(class_2960 id, class_2540 buf) {
            class_1856 mainhand = class_1856.method_8086((class_2540)buf);
            class_1856 offhand = buf.readBoolean() ? class_1856.method_8086((class_2540)buf) : class_1856.field_9017;
            boolean consumesOffhand = buf.readBoolean();
            ArrayList statChanges = new ArrayList();
            int size = buf.readByte();
            for (int i = 0; i < size; ++i) {
                statChanges.add(StatModifier.read(buf));
            }
            return new SpawnerModifier(id, mainhand, offhand, consumesOffhand, statChanges);
        }

        public void toNetwork(class_2540 buf, SpawnerModifier recipe) {
            recipe.mainHand.method_8088(buf);
            buf.writeBoolean(recipe.offHand != class_1856.field_9017);
            if (recipe.offHand != class_1856.field_9017) {
                recipe.offHand.method_8088(buf);
            }
            buf.writeBoolean(recipe.consumesOffhand);
            buf.writeByte(recipe.statChanges.size());
            recipe.statChanges.forEach(m -> m.write(buf));
        }
    }
}

