/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mixin.accessors.BlockAccessor;
import dev.shadowsoffire.apotheosis.mixin.accessors.DropExperienceBlockAccessor;
import dev.shadowsoffire.apotheosis.village.VillageModule;
import io.github.fabricators_of_create.porting_lib.util.UsernameCache;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2431;
import net.minecraft.class_2449;
import net.minecraft.class_2496;
import net.minecraft.class_2515;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3748;
import org.jetbrains.annotations.Nullable;

public class BlockUtil {
    public static boolean breakExtraBlock(class_3218 world, class_2338 pos, class_1799 mainhand, @Nullable UUID source) {
        FakePlayer player;
        if (Apotheosis.enableDebug) {
            VillageModule.LOGGER.info("Breaking extra blocks");
        }
        class_2680 blockstate = world.method_8320(pos);
        if (source != null) {
            if (Apotheosis.enableDebug) {
                VillageModule.LOGGER.info("Source: {} is not null", (Object)source);
            }
            player = FakePlayer.get((class_3218)world, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source)));
            class_1657 realPlayer = world.method_18470(source);
            if (realPlayer != null) {
                player.method_33574(realPlayer.method_19538());
            }
        } else {
            player = FakePlayer.get((class_3218)world);
        }
        player.method_31548().field_7547.set(player.method_31548().field_7545, (Object)mainhand);
        if (blockstate.method_26214((class_1922)world, pos) < 0.0f) {
            if (Apotheosis.enableDebug) {
                VillageModule.LOGGER.info("Destroy speed too low {}", (Object)blockstate);
            }
            return false;
        }
        class_1934 type = player.method_31549().field_7477 ? class_1934.field_9220 : class_1934.field_9215;
        int exp = BlockUtil.getXpForBlock(blockstate, world);
        class_2586 tileentity = world.method_8321(pos);
        class_2248 block = blockstate.method_26204();
        if ((block instanceof class_2288 || block instanceof class_2515 || block instanceof class_3748) && !player.method_7338()) {
            world.method_8413(pos, blockstate, blockstate, 3);
            if (Apotheosis.enableDebug) {
                VillageModule.LOGGER.info("Block \"{}\" is an unbreakable block, cancelling", (Object)block);
            }
            return false;
        }
        if (player.method_6047().onBlockStartBreak(pos, (class_1657)player)) {
            if (Apotheosis.enableDebug) {
                VillageModule.LOGGER.info("onBlockStartBreak was cancelled, cancelling");
            }
            return false;
        }
        if (player.method_21701((class_1937)world, pos, type)) {
            if (Apotheosis.enableDebug) {
                VillageModule.LOGGER.info("Block action is restricted, cancelling");
            }
            return false;
        }
        if (player.method_31549().field_7477) {
            BlockUtil.removeBlock(world, (class_3222)player, pos, false);
            return true;
        }
        class_1799 itemstack = player.method_6047();
        class_1799 itemstack1 = itemstack.method_7972();
        boolean canHarvest = mainhand.method_7951(blockstate) || BlockUtil.canHarvest(blockstate);
        itemstack.method_7952((class_1937)world, blockstate, pos, (class_1657)player);
        boolean removed = BlockUtil.removeBlock(world, (class_3222)player, pos, canHarvest);
        if (removed && canHarvest) {
            block.method_9556((class_1937)world, (class_1657)player, pos, blockstate, tileentity, itemstack1);
        }
        if (removed && exp > 0) {
            ((BlockAccessor)blockstate.method_26204()).callPopExperience(world, pos, exp);
        }
        return true;
    }

    public static boolean removeBlock(class_3218 world, class_3222 player, class_2338 pos, boolean canHarvest) {
        class_2680 state = world.method_8320(pos);
        boolean removed = BlockUtil.onDestroyedByPlayer(state, (class_1937)world, pos, (class_1657)player, canHarvest, world.method_8316(pos));
        if (removed) {
            state.method_26204().method_9585((class_1936)world, pos, state);
        }
        return removed;
    }

    private static int getXpForBlock(class_2680 state, class_3218 level) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2431) {
            class_2431 ore = (class_2431)class_22482;
            return ((DropExperienceBlockAccessor)ore).getXpRange().method_35008(level.field_9229);
        }
        if (state.method_26204() instanceof class_2449) {
            return 1 + level.field_9229.method_43048(5);
        }
        if (state.method_26204() instanceof class_2496) {
            return 15 + level.field_9229.method_43048(15) + level.field_9229.method_43048(15);
        }
        return 0;
    }

    private static boolean onDestroyedByPlayer(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, boolean willHarvest, class_3610 fluid) {
        state.method_26204().method_9576(level, pos, state, player);
        return level.method_8652(pos, fluid.method_15759(), level.field_9236 ? 11 : 3);
    }

    private static boolean canHarvest(class_2680 state) {
        if (!state.method_29291()) {
            return true;
        }
        return !state.method_29291();
    }
}

