/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.attributeslib.client.ModifierSourceType;
import dev.shadowsoffire.attributeslib.util.Comparators;
import java.util.Comparator;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_7923;

public abstract class ModifierSource<T>
implements Comparable<ModifierSource<T>> {
    protected final ModifierSourceType<T> type;
    protected final Comparator<T> comparator;
    protected final T data;

    public ModifierSource(ModifierSourceType<T> type, Comparator<T> comparator, T data) {
        this.type = type;
        this.comparator = comparator;
        this.data = data;
    }

    public abstract void render(class_332 var1, class_327 var2, int var3, int var4);

    public ModifierSourceType<T> getType() {
        return this.type;
    }

    public final T getData() {
        return this.data;
    }

    @Override
    public int compareTo(ModifierSource<T> o) {
        return this.comparator.compare(this.getData(), o.getData());
    }

    public static class EffectModifierSource
    extends ModifierSource<class_1293> {
        public EffectModifierSource(class_1293 data) {
            super(ModifierSourceType.MOB_EFFECT, Comparator.comparing(class_1293::method_5579, Comparators.idComparator(class_7923.field_41174)), data);
        }

        @Override
        public void render(class_332 gfx, class_327 font, int x, int y) {
            class_4074 texMgr = class_310.method_1551().method_18505();
            class_1291 effect = ((class_1293)this.data).method_5579();
            class_1058 sprite = texMgr.method_18663(effect);
            float scale = 0.5f;
            class_4587 stack = gfx.method_51448();
            stack.method_22903();
            stack.method_22905(scale, scale, 1.0f);
            stack.method_46416((float)x / scale, (float)y / scale, 0.0f);
            gfx.method_25298(0, 0, 0, 18, 18, sprite);
            stack.method_22909();
        }
    }

    public static class ItemModifierSource
    extends ModifierSource<class_1799> {
        public ItemModifierSource(class_1799 data) {
            super(ModifierSourceType.EQUIPMENT, Comparator.comparing(class_1309::method_32326).reversed().thenComparing(Comparator.comparing(class_1799::method_7909, Comparators.idComparator(class_7923.field_41178))), data);
        }

        @Override
        public void render(class_332 gfx, class_327 font, int x, int y) {
            class_4587 pose = gfx.method_51448();
            pose.method_22903();
            float scale = 0.5f;
            pose.method_22905(scale, scale, 1.0f);
            pose.method_46416(1.0f + (float)x / scale, 1.0f + (float)y / scale, 0.0f);
            gfx.method_51445((class_1799)this.data, 0, 0);
            pose.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }
}

