/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.nio.charset.StandardCharsets;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmTypeTransformer
implements RfbClassTransformer {
    public static final Attributes.Name MANIFEST_SAFE_ATTRIBUTE = new Attributes.Name("Has-Safe-AsmGetTypeUsage");
    private static final byte[] quickScan = "org/objectweb/asm/Type".getBytes(StandardCharsets.UTF_8);

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "asm-type-fixer";
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        if (manifest != null && "true".equals(manifest.getMainAttributes().getValue(MANIFEST_SAFE_ATTRIBUTE))) {
            return false;
        }
        if (classNode.getOriginalMetadata() != null && classNode.getOriginalMetadata().majorVersion >= 53) {
            return false;
        }
        if (classNode.isOriginal()) {
            byte[] original = classNode.getOriginalBytes();
            return ClassHeaderMetadata.hasSubstring(original, quickScan);
        }
        return true;
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode node = classNode.getNode();
        if (node == null) {
            return;
        }
        if (node.methods == null) {
            return;
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode insn : method.instructions) {
                if (insn.getType() != 5) continue;
                MethodInsnNode mi = (MethodInsnNode)insn;
                if (!"org/objectweb/asm/Type".equals(mi.owner) || !"getType".equals(mi.name) || !"(Ljava/lang/String;)Lorg/objectweb/asm/Type;".equals(mi.desc)) continue;
                mi.owner = "com/gtnewhorizons/retrofuturabootstrap/asm/SafeAsmType";
            }
        }
    }
}

