/*
 * Decompiled with CFR 0.152.
 */
package simplefpsmod;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Configuration;

public class FpsHandler {
    private boolean showFPS;
    private int positionState;
    private int colorIndex;
    private final KeyBinding keyToggle;
    private final KeyBinding keyPosition;
    private final KeyBinding keyColor;
    private final Configuration config;
    private static final int[][] POSITIONS = new int[][]{{5, 5}, {1, 5}, {5, 1}, {1, 1}};
    private static final EnumChatFormatting[] COLORS = new EnumChatFormatting[]{EnumChatFormatting.GREEN, EnumChatFormatting.RED, EnumChatFormatting.DARK_RED, EnumChatFormatting.GOLD, EnumChatFormatting.YELLOW, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.BLUE, EnumChatFormatting.DARK_BLUE, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.DARK_PURPLE, EnumChatFormatting.GRAY, EnumChatFormatting.DARK_GRAY, EnumChatFormatting.WHITE};

    public FpsHandler(Configuration config) {
        this.config = config;
        this.loadConfig();
        this.keyToggle = new KeyBinding("key.toggleFPS", 22, "fps.settings.category");
        this.keyPosition = new KeyBinding("key.togglePosition", 27, "fps.settings.category");
        this.keyColor = new KeyBinding("key.toggleColor", 40, "fps.settings.category");
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyToggle);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyPosition);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyColor);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void loadConfig() {
        this.config.load();
        this.showFPS = this.config.getBoolean("showFPS", "general", false, "Show FPS on screen");
        this.positionState = this.config.getInt("positionState", "general", 0, 0, POSITIONS.length - 1, "Current position state");
        this.colorIndex = this.config.getInt("colorIndex", "general", 0, 0, COLORS.length - 1, "Current color index");
        this.config.save();
    }

    private void saveConfig() {
        this.config.load();
        this.config.get("general", "showFPS", false).set(this.showFPS);
        this.config.get("general", "positionState", 0).set(this.positionState);
        this.config.get("general", "colorIndex", 0).set(this.colorIndex);
        this.config.save();
    }

    @SubscribeEvent
    public void handleEvent(InputEvent.KeyInputEvent event) {
        if (this.keyToggle.func_151468_f()) {
            this.showFPS = !this.showFPS;
            this.saveConfig();
        }
        if (this.keyPosition.func_151468_f()) {
            this.positionState = (this.positionState + 1) % POSITIONS.length;
            this.saveConfig();
        }
        if (this.keyColor.func_151468_f()) {
            this.colorIndex = (this.colorIndex + 1) % COLORS.length;
            this.saveConfig();
        }
    }

    @SubscribeEvent
    public void handleRenderEvent(RenderGameOverlayEvent.Text event) {
        if (this.showFPS) {
            int posY;
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            String[] debugInfo = mc.field_71426_K.split(" ");
            String fpsText = COLORS[this.colorIndex] + "FPS: " + debugInfo[0];
            int posX = POSITIONS[this.positionState][0] == 1 ? sr.func_78326_a() - mc.field_71466_p.func_78256_a(fpsText) - 5 : POSITIONS[this.positionState][0];
            int n = posY = POSITIONS[this.positionState][1] == 1 ? sr.func_78328_b() - mc.field_71466_p.field_78288_b - 5 : POSITIONS[this.positionState][1];
            if (posX < 0) {
                posX = 0;
            }
            if (posY < 0) {
                posY = 0;
            }
            if (posX > sr.func_78326_a() - mc.field_71466_p.func_78256_a(fpsText)) {
                posX = sr.func_78326_a() - mc.field_71466_p.func_78256_a(fpsText);
            }
            if (posY > sr.func_78328_b() - mc.field_71466_p.field_78288_b) {
                posY = sr.func_78328_b() - mc.field_71466_p.field_78288_b;
            }
            int color = 0xFFFFFF;
            mc.field_71466_p.func_78276_b(fpsText, posX, posY, color);
        }
    }
}

