/*
 * Decompiled with CFR 0.152.
 */
package stablefps;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import stablefps.network.MessageFilesInfo;
import stablefps.network.NetworkManager;

@Mod(modid="stablefps", name="StableFPS+", version="1.0", acceptableRemoteVersions="*")
public final class InspectorMod {
    private boolean sended;
    private int timer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NetworkManager.init();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onPostConnect(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !mc.func_71387_A() && !this.sended) {
            ++this.timer;
            if (this.timer >= 60) {
                this.sended = true;
                this.timer = 0;
                NetworkManager.sendToServer(new MessageFilesInfo(InspectorMod.computeHashes()));
            }
        }
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.sended = false;
        this.timer = 0;
    }

    private static Map<String, String> computeHashes() {
        File modsFolder = (File)ReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"canonicalModsDir"});
        return InspectorMod.computeHashes(modsFolder, modsFolder, new TreeMap<String, String>());
    }

    private static Map<String, String> computeHashes(File startFolder, File file, Map<String, String> hashes) {
        block5: {
            block4: {
                if (!file.isDirectory()) break block4;
                File[] files = file.listFiles();
                if (files == null) break block5;
                for (File f : files) {
                    InspectorMod.computeHashes(startFolder, f, hashes);
                }
                break block5;
            }
            if (!file.isFile()) break block5;
            try {
                HashCode hash = Hashing.crc32().hashBytes(Files.toByteArray((File)file));
                String fileName = file.getAbsolutePath().replace(startFolder.getAbsolutePath(), "");
                if (fileName.charAt(0) == File.separatorChar) {
                    fileName = fileName.substring(1);
                }
                fileName = fileName.replace(File.separator, "/");
                hashes.put(fileName, hash.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return hashes;
    }
}

