/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.lists;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;

public class ChunkRenderList<T> {
    private T[] stateArray;
    private int[] cullArray;
    private int size = 0;
    private int capacity;

    public ChunkRenderList() {
        this(1024);
    }

    public ChunkRenderList(int capacity) {
        this.capacity = capacity;
        this.stateArray = new Object[capacity];
        this.cullArray = new int[capacity];
    }

    private void resize() {
        this.capacity *= 2;
        this.stateArray = Arrays.copyOf(this.stateArray, this.capacity);
        this.cullArray = Arrays.copyOf(this.cullArray, this.capacity);
    }

    public void add(T state, int cull) {
        int idx;
        if ((idx = this.size++) >= this.capacity) {
            this.resize();
        }
        this.stateArray[idx] = state;
        this.cullArray[idx] = cull;
    }

    public void reset() {
        int i;
        if (this.size == 0) {
            return;
        }
        for (i = 0; i < this.size; ++i) {
            this.stateArray[i] = null;
        }
        for (i = 0; i < this.size; ++i) {
            this.cullArray[i] = 0;
        }
        this.size = 0;
    }

    public ChunkRenderListIterator<T> iterator(boolean backwards) {
        if (backwards) {
            return new ChunkRenderListIterator<T>(){
                private int pos;
                {
                    this.pos = ChunkRenderList.this.size - 1;
                }

                @Override
                public T getGraphicsState() {
                    return ChunkRenderList.this.stateArray[this.pos];
                }

                @Override
                public int getVisibleFaces() {
                    return ChunkRenderList.this.cullArray[this.pos];
                }

                @Override
                public boolean hasNext() {
                    return this.pos >= 0;
                }

                @Override
                public void advance() {
                    --this.pos;
                }
            };
        }
        return new ChunkRenderListIterator<T>(){
            private final int lim;
            private int pos;
            {
                this.lim = ChunkRenderList.this.size;
                this.pos = 0;
            }

            @Override
            public T getGraphicsState() {
                return ChunkRenderList.this.stateArray[this.pos];
            }

            @Override
            public int getVisibleFaces() {
                return ChunkRenderList.this.cullArray[this.pos];
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.lim;
            }

            @Override
            public void advance() {
                ++this.pos;
            }
        };
    }
}

