/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import com.gtnewhorizons.angelica.compat.mojang.ChunkSectionPos;
import com.gtnewhorizons.angelica.compat.mojang.CompatMathHelper;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import java.util.Arrays;
import lombok.Generated;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldSlice
implements IBlockAccess {
    private static final EnumSkyBlock[] LIGHT_TYPES = EnumSkyBlock.values();
    private static final int SECTION_BLOCK_LENGTH = 16;
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = CompatMathHelper.roundUpToMultiple(2, 16) >> 4;
    private static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int TABLE_LENGTH = CompatMathHelper.smallestEncompassingPowerOfTwo(SECTION_LENGTH);
    private static final int TABLE_BITS = Integer.bitCount(TABLE_LENGTH - 1);
    private static final int SECTION_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH * TABLE_LENGTH;
    private final WorldClient world;
    private final Block[][] blockArrays;
    private final int[][] metadataArrays;
    private final NibbleArray[][] lightArrays;
    private ClonedChunkSection[] sections;
    private BiomeGenBase[][] biomeData;
    private int baseX;
    private int baseY;
    private int baseZ;
    private final int worldHeight;
    private final int[] defaultLightValues;
    private ChunkSectionPos origin;
    StructureBoundingBox volume;

    public static ChunkRenderContext prepare(World world, ChunkSectionPos origin, ClonedChunkSectionCache sectionCache) {
        Chunk chunk = world.func_72964_e(origin.x, origin.z);
        ExtendedBlockStorage section = chunk.func_76587_i()[origin.y];
        if (section == null || section.func_76663_a()) {
            return null;
        }
        StructureBoundingBox volume = new StructureBoundingBox(origin.getMinX() - 2, origin.getMinY() - 2, origin.getMinZ() - 2, origin.getMaxX() + 2, origin.getMaxY() + 2, origin.getMaxZ() + 2);
        int minChunkX = origin.x - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.y - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.z - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.x + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.y + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.z + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume);
    }

    public WorldSlice(WorldClient world) {
        this.world = world;
        this.worldHeight = world.func_72800_K();
        this.defaultLightValues = new int[LIGHT_TYPES.length];
        this.defaultLightValues[EnumSkyBlock.Sky.ordinal()] = world.field_73011_w.field_76576_e ? 0 : EnumSkyBlock.Sky.field_77198_c;
        this.defaultLightValues[EnumSkyBlock.Block.ordinal()] = EnumSkyBlock.Block.field_77198_c;
        this.sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        this.blockArrays = new Block[SECTION_TABLE_ARRAY_SIZE][];
        this.metadataArrays = new int[SECTION_TABLE_ARRAY_SIZE][];
        this.biomeData = new BiomeGenBase[SECTION_TABLE_ARRAY_SIZE][];
        this.lightArrays = new NibbleArray[SECTION_TABLE_ARRAY_SIZE][LIGHT_TYPES.length];
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int i = WorldSlice.getLocalSectionIndex(x, y, z);
                    this.blockArrays[i] = new Block[4096];
                    Arrays.fill(this.blockArrays[i], Blocks.field_150350_a);
                    this.metadataArrays[i] = new int[4096];
                }
            }
        }
    }

    public void copyData(ChunkRenderContext context) {
        this.origin = context.getOrigin();
        this.sections = context.getSections();
        this.volume = context.getVolume();
        this.baseX = this.origin.x - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseY = this.origin.y - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseZ = this.origin.z - NEIGHBOR_CHUNK_RADIUS << 4;
        Arrays.fill((Object[])this.biomeData, null);
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int idx = WorldSlice.getLocalSectionIndex(x, y, z);
                    ClonedChunkSection section = this.sections[idx];
                    this.unpackBlockData(this.blockArrays[idx], this.metadataArrays[idx], section, context.getVolume());
                    this.biomeData[idx] = section.getBiomeData();
                    this.lightArrays[idx][EnumSkyBlock.Block.ordinal()] = section.getLightArray(EnumSkyBlock.Block);
                    this.lightArrays[idx][EnumSkyBlock.Sky.ordinal()] = section.getLightArray(EnumSkyBlock.Sky);
                }
            }
        }
    }

    public int func_72802_i(int x, int y, int z, int min) {
        if (y < 0 || y >= 256 || x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return 0xF00000 | min << 4;
        }
        int skyBrightness = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, x, y, z);
        int blockBrightness = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, x, y, z);
        if (blockBrightness < min) {
            blockBrightness = min;
        }
        if (DynamicLights.isEnabled() && !this.func_147439_a(x, y, z).func_149662_c()) {
            return DynamicLights.get().getLightmapWithDynamicLight(x, y, z, skyBrightness << 20 | blockBrightness << 4);
        }
        return skyBrightness << 20 | blockBrightness << 4;
    }

    private int getSkyBlockTypeBrightness(EnumSkyBlock skyBlock, int x, int y, int z) {
        if (this.func_147439_a(x, y, z).func_149710_n()) {
            int yp = this.getLightLevel(skyBlock, x, y + 1, z);
            int xp = this.getLightLevel(skyBlock, x + 1, y, z);
            int xm = this.getLightLevel(skyBlock, x - 1, y, z);
            int zp = this.getLightLevel(skyBlock, x, y, z + 1);
            int zm = this.getLightLevel(skyBlock, x, y, z - 1);
            if (xp > yp) {
                yp = xp;
            }
            if (xm > yp) {
                yp = xm;
            }
            if (zp > yp) {
                yp = zp;
            }
            if (zm > yp) {
                yp = zm;
            }
            return yp;
        }
        return this.getLightLevel(skyBlock, x, y, z);
    }

    public int func_72879_k(int x, int y, int z, int directionIn) {
        return this.func_147439_a(x, y, z).func_149748_c((IBlockAccess)this, x, y, z, directionIn);
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public BiomeGenBase func_72807_a(int x, int z) {
        if (!WorldSlice.blockBoxContains(this.volume, x, this.volume.field_78895_b, z)) {
            return BiomeGenBase.field_76772_c;
        }
        int relX = x - this.baseX;
        boolean relY = false;
        int relZ = z - this.baseZ;
        BiomeGenBase biome = this.biomeData[WorldSlice.getLocalSectionIndex(relX >> 4, 0, relZ >> 4)][x & 0xF | (z & 0xF) << 4];
        return biome == null ? BiomeGenBase.field_76772_c : biome;
    }

    public int func_72800_K() {
        return this.worldHeight;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    private void unpackBlockData(Block[] blocks, int[] metas, ClonedChunkSection section, StructureBoundingBox box) {
        if (this.origin.equals((Object)section.getPosition())) {
            this.unpackBlockDataZ(blocks, metas, section);
        } else {
            this.unpackBlockDataR(blocks, metas, section, box);
        }
    }

    private static void copyBlocks(Block[] blocks, int[] metas, ClonedChunkSection section, int minBlockY, int maxBlockY, int minBlockZ, int maxBlockZ, int minBlockX, int maxBlockX) {
        for (int y = minBlockY; y <= maxBlockY; ++y) {
            for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                for (int x = minBlockX; x <= maxBlockX; ++x) {
                    int blockIdx = WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                    blocks[blockIdx] = section.getBlock(x & 0xF, y & 0xF, z & 0xF);
                    metas[blockIdx] = section.getBlockMetadata(x & 0xF, y & 0xF, z & 0xF);
                }
            }
        }
    }

    private void unpackBlockDataR(Block[] blocks, int[] metas, ClonedChunkSection section, StructureBoundingBox box) {
        ChunkSectionPos pos = section.getPosition();
        int minBlockX = Math.max(box.field_78897_a, pos.getMinX());
        int maxBlockX = Math.min(box.field_78893_d, pos.getMaxX());
        int minBlockY = Math.max(box.field_78895_b, pos.getMinY());
        int maxBlockY = Math.min(box.field_78894_e, pos.getMaxY());
        int minBlockZ = Math.max(box.field_78896_c, pos.getMinZ());
        int maxBlockZ = Math.min(box.field_78892_f, pos.getMaxZ());
        WorldSlice.copyBlocks(blocks, metas, section, minBlockY, maxBlockY, minBlockZ, maxBlockZ, minBlockX, maxBlockX);
    }

    private void unpackBlockDataZ(Block[] blocks, int[] metas, ClonedChunkSection section) {
        ChunkSectionPos pos = section.getPosition();
        int minBlockX = pos.getMinX();
        int maxBlockX = pos.getMaxX();
        int minBlockY = pos.getMinY();
        int maxBlockY = pos.getMaxY();
        int minBlockZ = pos.getMinZ();
        int maxBlockZ = pos.getMaxZ();
        WorldSlice.copyBlocks(blocks, metas, section, minBlockY, maxBlockY, minBlockZ, maxBlockZ, minBlockX, maxBlockX);
    }

    public Block func_147439_a(int x, int y, int z) {
        if (!WorldSlice.blockBoxContains(this.volume, x, y, z)) {
            return Blocks.field_150350_a;
        }
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.blockArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public Block getBlockRelative(int x, int y, int z) {
        return this.blockArrays[WorldSlice.getLocalSectionIndex(x >> 4, y >> 4, z >> 4)][WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF)];
    }

    public int getBlockMetadataRelative(int x, int y, int z) {
        return this.metadataArrays[WorldSlice.getLocalSectionIndex(x >> 4, y >> 4, z >> 4)][WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF)];
    }

    public int func_72805_g(int x, int y, int z) {
        if (!WorldSlice.blockBoxContains(this.volume, x, y, z)) {
            return 0;
        }
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.metadataArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        if (!WorldSlice.blockBoxContains(this.volume, x, y, z)) {
            return null;
        }
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBlockEntity(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int getLightLevel(EnumSkyBlock type, int x, int y, int z) {
        int relZ;
        if (!WorldSlice.blockBoxContains(this.volume, x, y, z)) {
            return 0;
        }
        int relX = x - this.baseX;
        int relY = (y = MathHelper.func_76125_a((int)y, (int)0, (int)255)) - this.baseY;
        NibbleArray lightArray = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, (relZ = z - this.baseZ) >> 4)][type.ordinal()];
        if (lightArray == null) {
            return this.defaultLightValues[type.ordinal()];
        }
        return lightArray.func_76582_a(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y << TABLE_BITS << TABLE_BITS | z << TABLE_BITS | x;
    }

    public static int getLocalChunkIndex(int x, int z) {
        return z << TABLE_BITS | x;
    }

    public float getBrightness(ForgeDirection direction, boolean shaded) {
        float f;
        if (!shaded) {
            return this.world.field_73011_w.field_76576_e ? 0.9f : 1.0f;
        }
        switch (direction) {
            case DOWN: {
                f = 0.5f;
                break;
            }
            case UP: {
                f = 1.0f;
                break;
            }
            case NORTH: 
            case SOUTH: {
                f = 0.8f;
                break;
            }
            default: {
                f = 0.6f;
            }
        }
        return f;
    }

    public World getWorld() {
        return this.world;
    }

    private static boolean blockBoxContains(StructureBoundingBox box, int x, int y, int z) {
        return x >= box.field_78897_a && x <= box.field_78893_d && y >= box.field_78895_b && y <= box.field_78894_e && z >= box.field_78896_c && z <= box.field_78892_f;
    }

    @Generated
    public ChunkSectionPos getOrigin() {
        return this.origin;
    }
}

