/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL11;

public class StandardMacros {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.*(?<bugfix>\\d*)(.*)");

    private static void define(List<StringPair> defines, String key) {
        defines.add(new StringPair(key, ""));
    }

    private static void define(List<StringPair> defines, String key, String value) {
        defines.add(new StringPair(key, value));
    }

    public static Iterable<StringPair> createStandardEnvironmentDefines() {
        ArrayList<StringPair> standardDefines = new ArrayList<StringPair>();
        StandardMacros.define(standardDefines, "MC_VERSION", StandardMacros.getMcVersion());
        StandardMacros.define(standardDefines, "MC_GL_VERSION", StandardMacros.getGlVersion(7938));
        StandardMacros.define(standardDefines, "MC_GLSL_VERSION", StandardMacros.getGlVersion(35724));
        StandardMacros.define(standardDefines, StandardMacros.getOsString());
        StandardMacros.define(standardDefines, StandardMacros.getVendor());
        StandardMacros.define(standardDefines, StandardMacros.getRenderer());
        for (String glExtension : StandardMacros.getGlExtensions()) {
            StandardMacros.define(standardDefines, glExtension);
        }
        StandardMacros.define(standardDefines, "MC_NORMAL_MAP");
        StandardMacros.define(standardDefines, "MC_SPECULAR_MAP");
        StandardMacros.define(standardDefines, "MC_RENDER_QUALITY", "1.0");
        StandardMacros.define(standardDefines, "MC_SHADOW_QUALITY", "1.0");
        StandardMacros.define(standardDefines, "IS_ANGELICA");
        StandardMacros.define(standardDefines, "ANGELICA_VERSION", "1.0.0-beta34");
        StandardMacros.define(standardDefines, "MC_HAND_DEPTH", Float.toString(0.125f));
        TextureFormat textureFormat = TextureFormatLoader.getFormat();
        if (textureFormat != null) {
            for (String define : textureFormat.getDefines()) {
                StandardMacros.define(standardDefines, define);
            }
        }
        StandardMacros.getRenderStages().forEach((stage, index) -> StandardMacros.define(standardDefines, stage, index));
        for (String irisDefine : StandardMacros.getIrisDefines()) {
            StandardMacros.define(standardDefines, irisDefine);
        }
        return ImmutableList.copyOf(standardDefines);
    }

    public static String getMcVersion() {
        String version = "1.7.10";
        String[] splitVersion = "1.7.10".split("\\.");
        if (splitVersion.length < 2) {
            throw new IllegalStateException("Could not parse game version \"1.7.10\"");
        }
        String major = splitVersion[0];
        String minor = splitVersion[1];
        String bugfix = splitVersion.length < 3 ? "00" : splitVersion[2];
        if (minor.length() == 1) {
            minor = 0 + minor;
        }
        if (bugfix.length() == 1) {
            bugfix = 0 + bugfix;
        }
        return major + minor + bugfix;
    }

    public static String getGlVersion(int name) {
        String info = GL11.glGetString((int)name);
        Matcher matcher = SEMVER_PATTERN.matcher(Objects.requireNonNull(info));
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse GL version from \"" + info + "\"");
        }
        String major = StandardMacros.group(matcher, "major");
        String minor = StandardMacros.group(matcher, "minor");
        String bugfix = StandardMacros.group(matcher, "bugfix");
        if (bugfix == null) {
            bugfix = "0";
        }
        if (major == null || minor == null) {
            throw new IllegalStateException("Could not parse GL version from \"" + info + "\"");
        }
        return major + minor + bugfix;
    }

    public static String group(Matcher matcher, String name) {
        try {
            return matcher.group(name);
        }
        catch (IllegalArgumentException | IllegalStateException exception) {
            return null;
        }
    }

    public static String getOsString() {
        String string;
        switch (LWJGLUtil.getPlatform()) {
            case 2: {
                string = "MC_OS_MAC";
                break;
            }
            case 1: {
                string = "MC_OS_LINUX";
                break;
            }
            case 3: {
                string = "MC_OS_WINDOWS";
                break;
            }
            default: {
                string = "MC_OS_UNKNOWN";
            }
        }
        return string;
    }

    public static String getVendor() {
        String vendor = Objects.requireNonNull(GL11.glGetString((int)7936)).toLowerCase(Locale.ROOT);
        if (vendor.startsWith("ati")) {
            return "MC_GL_VENDOR_ATI";
        }
        if (vendor.startsWith("intel")) {
            return "MC_GL_VENDOR_INTEL";
        }
        if (vendor.startsWith("nvidia")) {
            return "MC_GL_VENDOR_NVIDIA";
        }
        if (vendor.startsWith("amd")) {
            return "MC_GL_VENDOR_AMD";
        }
        if (vendor.startsWith("x.org")) {
            return "MC_GL_VENDOR_XORG";
        }
        return "MC_GL_VENDOR_OTHER";
    }

    public static String getRenderer() {
        String renderer = Objects.requireNonNull(GL11.glGetString((int)7937)).toLowerCase(Locale.ROOT);
        if (renderer.startsWith("amd")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("ati")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("radeon")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("gallium")) {
            return "MC_GL_RENDERER_GALLIUM";
        }
        if (renderer.startsWith("intel")) {
            return "MC_GL_RENDERER_INTEL";
        }
        if (renderer.startsWith("geforce")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (renderer.startsWith("nvidia")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (renderer.startsWith("quadro")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (renderer.startsWith("nvs")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (renderer.startsWith("mesa")) {
            return "MC_GL_RENDERER_MESA";
        }
        return "MC_GL_RENDERER_OTHER";
    }

    public static Set<String> getGlExtensions() {
        String[] extensions = Objects.requireNonNull(GL11.glGetString((int)7939)).split("\\s+");
        return Arrays.stream(extensions).map(s -> "MC_" + s).collect(Collectors.toSet());
    }

    public static Map<String, String> getRenderStages() {
        HashMap<String, String> stages = new HashMap<String, String>();
        for (WorldRenderingPhase phase : WorldRenderingPhase.values()) {
            stages.put("MC_RENDER_STAGE_" + phase.name(), String.valueOf(phase.ordinal()));
        }
        return stages;
    }

    public static List<String> getIrisDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        return defines;
    }
}

