/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.shaderselection;

import lombok.Generated;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.shaderselection.BaseEntry;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;

public class ShaderPackEntry
extends BaseEntry {
    private final String packName;
    private final ShaderPackSelectionList shaderPackSelectionList;
    private final int index;

    public ShaderPackEntry(int index, ShaderPackSelectionList list, String packName) {
        super(list);
        this.packName = packName;
        this.shaderPackSelectionList = list;
        this.index = index;
    }

    public boolean isApplied() {
        return this.shaderPackSelectionList.getApplied() == this;
    }

    public boolean isSelected() {
        return this.shaderPackSelectionList.getSelected() == this;
    }

    @Override
    public void drawEntry(ShaderPackScreen screen, int index, int x, int y, int listWidth, Tessellator tessellator, int mouseX, int mouseY, boolean isMouseOver) {
        FontRenderer font = screen.getFontRenderer();
        boolean shadersEnabled = this.shaderPackSelectionList.getTopButtonRow().shadersEnabled;
        int color = 0xFFFFFF;
        String name = this.packName;
        if (font.func_78256_a(name) > this.list.func_148139_c() - 3) {
            name = font.func_78269_a(name, this.list.func_148139_c() - 8) + "...";
        }
        if (isMouseOver) {
            name = EnumChatFormatting.BOLD + name;
        }
        if (this.isApplied()) {
            color = 16773731;
        }
        if (!shadersEnabled && !isMouseOver) {
            color = 0xA2A2A2;
        }
        screen.drawCenteredString(name, x + listWidth / 2 - 2, y, color);
    }

    @Generated
    public String getPackName() {
        return this.packName;
    }
}

