/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.Launch;

public class Internet {
    private static final Map<String, String> NO_HEADERS = Collections.emptyMap();

    public static void connect(URL URL2, Consumer<Exception> onError, Consumer<InputStream> onSuccess, Consumer<Long> contentLengthCallback) {
        Internet.connect(URL2, NO_HEADERS, onError, onSuccess, contentLengthCallback);
    }

    public static void connect(URL URL2, Map<String, String> headers, Consumer<Exception> onError, Consumer<InputStream> onSuccess, Consumer<Long> contentLengthCallback) {
        try {
            HttpURLConnection connection = (HttpURLConnection)URL2.openConnection();
            connection.setConnectTimeout(3500);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "FalsePatternLib 1.5.9 Internet Connector (https://github.com/FalsePattern/FalsePatternLib)");
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey();
                String value = header.getValue();
                if (key == null || value == null) {
                    throw new IllegalArgumentException("Null key or value");
                }
                if (key.isEmpty()) {
                    throw new IllegalArgumentException("Empty key");
                }
                connection.setRequestProperty(key, value);
            }
            if (connection.getResponseCode() != 200) {
                onError.accept(new Exception("HTTP response code " + connection.getResponseCode()));
            } else {
                contentLengthCallback.accept(connection.getContentLengthLong());
                onSuccess.accept(connection.getInputStream());
            }
            connection.disconnect();
        }
        catch (Exception e) {
            try {
                if (Launch.classLoader.getClassBytes("moe.mickey.forge.nonupdate.NonUpdate") != null) {
                    e.addSuppressed(new Exception("NonUpdate is present, it's possible that it's blocking a library download. Please disable it for a single run to allow mod dependencies to download."));
                }
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            onError.accept(e);
        }
    }

    public static void transferAndClose(InputStream is, OutputStream target, Consumer<Integer> downloadSizeCallback) throws IOException {
        int bytesRead = 0;
        byte[] smallBuffer = new byte[262144];
        while ((bytesRead = is.read(smallBuffer)) >= 0) {
            target.write(smallBuffer, 0, bytesRead);
            downloadSizeCallback.accept(bytesRead);
        }
        target.close();
        is.close();
    }
}

