/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm;

import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.impl.dependencies.DependencyLoaderImpl;
import com.falsepattern.lib.internal.logging.CrashImprover;
import com.falsepattern.lib.internal.logging.NotEnoughVerbosity;
import com.falsepattern.lib.mapping.MappingManager;
import com.falsepattern.lib.turboasm.MergeableTurboTransformer;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.Name(value="falsepatternlib")
@IFMLLoadingPlugin.SortingIndex(value=1100)
@IFMLLoadingPlugin.TransformerExclusions(value={"com.falsepattern.lib.internal.asm", "com.falsepattern.lib.asm", "com.falsepattern.lib.turboasm"})
public class CoreLoadingPlugin
implements IFMLLoadingPlugin {
    private static boolean obfuscated;

    private static Error skillIssue(String message) {
        int i;
        boolean padMSG;
        String shutup;
        int suWidth;
        int width = message.length();
        int padding = width - (suWidth = (shutup = "Any bug reports concerning this message will be silently deleted.").length());
        boolean bl = padMSG = padding < 0;
        if (padMSG) {
            padding = -padding;
        }
        int padLeft = padding / 2;
        int padRight = padding - padLeft;
        int maxWidth = Math.max(width, suWidth);
        StringBuilder bld = new StringBuilder("\n\n");
        for (i = 0; i < maxWidth + 2; ++i) {
            bld.append('-');
        }
        bld.append("\n|");
        if (padMSG) {
            for (i = 0; i < padLeft; ++i) {
                bld.append(' ');
            }
            bld.append(message);
            for (i = 0; i < padRight; ++i) {
                bld.append(' ');
            }
        } else {
            bld.append(message);
        }
        bld.append("|\n|");
        if (!padMSG) {
            for (i = 0; i < padLeft; ++i) {
                bld.append(' ');
            }
            bld.append(shutup);
            for (i = 0; i < padRight; ++i) {
                bld.append(' ');
            }
        } else {
            bld.append(shutup);
        }
        bld.append("|\n");
        for (i = 0; i < maxWidth + 2; ++i) {
            bld.append('-');
        }
        Error skillIssue = new Error(bld.toString());
        skillIssue.setStackTrace(new StackTraceElement[0]);
        return skillIssue;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"com.falsepattern.lib.internal.asm.FPTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        obfuscated = (Boolean)data.get("runtimeDeobfuscationEnabled");
        CoreLoadingPlugin.mergeTurboTransformers();
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static synchronized void mergeTurboTransformers() {
        Field f = LaunchClassLoader.class.getDeclaredField("transformers");
        f.setAccessible(true);
        List transformers = (List)f.get(Launch.classLoader);
        for (int i = 0; i < transformers.size() - 1; ++i) {
            IClassTransformer b;
            IClassTransformer a = (IClassTransformer)transformers.get(i);
            if (!(a instanceof MergeableTurboTransformer) || !((b = (IClassTransformer)transformers.get(i + 1)) instanceof MergeableTurboTransformer)) continue;
            transformers.remove(i + 1);
            transformers.set(i, MergeableTurboTransformer.merge((MergeableTurboTransformer)a, (MergeableTurboTransformer)b));
            --i;
        }
    }

    @Generated
    public static boolean isObfuscated() {
        return obfuscated;
    }

    static {
        FPLog.LOG.info("Removing skill issues...");
        try {
            Class.forName("thermos.Thermos");
            FPLog.LOG.fatal("Sorry, i prefer iced coffee.");
            throw CoreLoadingPlugin.skillIssue("Thermos is not supported by FalsePatternLib, please use a normal forge server.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FPLog.LOG.info("Scanning for deps...");
            long start = System.nanoTime();
            DependencyLoaderImpl.executeDependencyLoading(true);
            long end = System.nanoTime();
            FPLog.LOG.info("Scanned in " + (end - start) / 1000000L + "ms");
            MappingManager.initialize();
            NotEnoughVerbosity.apply();
            CrashImprover.probe();
            return;
        }
    }
}

