/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.config;

import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.config.MiscConfig;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.GuiIngameModOptions;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;

public final class InGameModOptionsFix {
    private static boolean isInitialized = false;
    private static Field MODS_FIELD;

    public static void init() {
        if (isInitialized) {
            return;
        }
        try {
            MODS_FIELD = GuiModList.class.getDeclaredField("mods");
            MODS_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            MODS_FIELD = null;
            FPLog.LOG.error("Failed to get field: cpw.mods.fml.client.GuiModList.mods, In-Game Mod Options Fix will not work", (Throwable)e);
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new InGameModOptionsFix());
        isInitialized = true;
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (!isInitialized) {
            return;
        }
        if (!MiscConfig.IN_GAME_MOD_OPTIONS_FIX) {
            return;
        }
        if (event.gui instanceof GuiIngameModOptions) {
            event.gui = new GuiModConfigList(Minecraft.func_71410_x().field_71462_r);
        }
    }

    @Generated
    private InGameModOptionsFix() {
    }

    private static class GuiModConfigList
    extends GuiModList {
        private GuiModConfigList(GuiScreen screen) {
            super(screen);
            ArrayList<ModContainer> mods = new ArrayList<ModContainer>();
            for (ModContainer mod : this.getModsFromPrivateField()) {
                IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(mod);
                if (guiFactory == null || guiFactory.mainConfigGuiClass() == null) continue;
                mods.add(mod);
            }
            this.setModsToPrivateField(mods);
        }

        private List<ModContainer> getModsFromPrivateField() {
            try {
                return (List)MODS_FIELD.get((Object)this);
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }

        private void setModsToPrivateField(List<ModContainer> mods) {
            try {
                MODS_FIELD.set((Object)this, mods);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

