/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.core;

import com.gtnewhorizons.retrofuturabootstrap.RfbApiImpl;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import net.minecraft.launchwrapper.Launch;
import org.jetbrains.annotations.NotNull;

public final class LowLevelCallMultiplexer {
    private static boolean rfbDetected = false;

    public static void rfbDetected() {
        rfbDetected = true;
    }

    public static void addURLToClassPath(URL url) {
        if (rfbDetected) {
            RFBLowLevel.addURLToClassPath(url);
        } else {
            LaunchWrapperLowLevel.addURLToClassPath(url);
        }
    }

    public static List<URL> getClassPathSources() {
        if (rfbDetected) {
            return RFBLowLevel.getClassPathSources();
        }
        return LaunchWrapperLowLevel.getClassPathSources();
    }

    @NotNull
    public static Path gameDir() {
        if (rfbDetected) {
            return RFBLowLevel.gameDir();
        }
        return LaunchWrapperLowLevel.gameDir();
    }

    @Generated
    private LowLevelCallMultiplexer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class RFBLowLevel {
        private RFBLowLevel() {
        }

        static void addURLToClassPath(URL url) {
            RfbApiImpl.INSTANCE.compatClassLoader().addURL(url);
        }

        static List<URL> getClassPathSources() {
            return RfbApiImpl.INSTANCE.compatClassLoader().getSources();
        }

        @NotNull
        static Path gameDir() {
            return RfbApiImpl.INSTANCE.gameDirectory();
        }
    }

    private static class LaunchWrapperLowLevel {
        private LaunchWrapperLowLevel() {
        }

        static void addURLToClassPath(URL url) {
            Launch.classLoader.addURL(url);
        }

        static List<URL> getClassPathSources() {
            return Launch.classLoader.getSources();
        }

        @NotNull
        static Path gameDir() {
            return Launch.minecraftHome == null ? Paths.get(".", new String[0]) : Launch.minecraftHome.toPath();
        }
    }
}

