/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.event;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigSyncEvent;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.FPLog;
import com.falsepattern.lib.internal.config.ConfigEngineConfig;
import com.falsepattern.lib.text.FormattedText;
import com.falsepattern.lib.toasts.GuiToast;
import com.falsepattern.lib.toasts.SimpleToast;
import com.falsepattern.lib.toasts.icon.ToastBG;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lombok.Generated;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandlerPre {
    private static final ClientEventHandlerPre INSTANCE = new ClientEventHandlerPre();

    public static void registerBus() {
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onValidationErrorToast(ConfigValidationFailureEvent e) {
        if (ConfigEngineConfig.CONFIG_ERROR_LOGGING == ConfigEngineConfig.LoggingLevel.LogAndToast) {
            e.toast();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConfigSyncFinished(ConfigSyncEvent.End e) {
        Config cfg = e.configClass.getAnnotation(Config.class);
        if (e.successful) {
            if (ConfigEngineConfig.CONFIG_SYNC_SUCCESS_LOGGING == ConfigEngineConfig.LoggingLevel.LogAndToast) {
                GuiToast.add(new SimpleToast(ToastBG.TOAST_DARK, null, (IChatComponent)FormattedText.parse(EnumChatFormatting.GREEN + "Synced config").toChatText().get(0), (IChatComponent)FormattedText.parse(cfg.modid() + ":" + cfg.category()).toChatText().get(0), false, 5000L));
            }
            if (ConfigEngineConfig.CONFIG_SYNC_SUCCESS_LOGGING != ConfigEngineConfig.LoggingLevel.None) {
                FPLog.LOG.info("Synced config: {}:{}", new Object[]{cfg.modid(), cfg.category()});
            }
        } else {
            if (ConfigEngineConfig.CONFIG_SYNC_FAILURE_LOGGING == ConfigEngineConfig.LoggingLevel.LogAndToast) {
                GuiToast.add(new SimpleToast(ToastBG.TOAST_DARK, null, (IChatComponent)FormattedText.parse(EnumChatFormatting.RED + "Failed to sync config").toChatText().get(0), (IChatComponent)FormattedText.parse(cfg.modid() + ":" + cfg.category()).toChatText().get(0), false, 5000L));
            }
            if (ConfigEngineConfig.CONFIG_SYNC_FAILURE_LOGGING != ConfigEngineConfig.LoggingLevel.None) {
                FPLog.LOG.error("Failed to sync config: {}:{}", new Object[]{cfg.modid(), cfg.category()});
                Throwable t = e.error;
                if (t != null) {
                    FPLog.LOG.error(t.getMessage(), t);
                }
            }
        }
    }

    @Generated
    private ClientEventHandlerPre() {
    }
}

