/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import net.minecraftforge.common.config.Property;

public class BooleanListConfigField
extends AListConfigField<boolean[], Config.DefaultBooleanList> {
    public BooleanListConfigField(ConfigFieldParameters params) throws ConfigException {
        super(params, Property.Type.BOOLEAN, Config.DefaultBooleanList.class, Config.DefaultBooleanList::value, Property::setDefaultValues);
        Property property = this.getProperty();
        if (!property.isBooleanList()) {
            this.setToDefault();
        }
        property.comment = property.comment + "\n[default: " + Arrays.toString((boolean[])this.defaultValue) + "]";
    }

    @Override
    protected int length(boolean[] arr) {
        return arr.length;
    }

    @Override
    protected boolean[] arrayCopy(boolean[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, boolean[] arr) throws IOException {
        byte[] transfer = new byte[arr.length + 7 >>> 3];
        for (int i = 0; i < arr.length; ++i) {
            int n = i >>> 3;
            transfer[n] = (byte)(transfer[n] | (arr[i] ? 1 << (i & 7) : 0));
        }
        for (byte i : transfer) {
            output.writeByte(i);
        }
    }

    @Override
    protected void receiveElements(DataInput input, boolean[] arr) throws IOException {
        int i;
        byte[] transfer = new byte[arr.length + 7 >>> 3];
        for (i = 0; i < transfer.length; ++i) {
            transfer[i] = input.readByte();
        }
        for (i = 0; i < arr.length; ++i) {
            arr[i] = (transfer[i >>> 3] & 1 << (i & 7)) != 0;
        }
    }

    @Override
    protected boolean[] createArray(int length) {
        return new boolean[length];
    }

    @Override
    protected boolean[] getConfig() {
        return this.getProperty().getBooleanList();
    }

    @Override
    protected void putConfig(boolean[] value) {
        this.getProperty().set(value);
    }

    @Override
    protected boolean[] getDefault() {
        return Arrays.copyOf((boolean[])this.defaultValue, ((boolean[])this.defaultValue).length);
    }
}

