/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.logging;

import com.falsepattern.lib.internal.FPLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;

public class CrashImprover {
    private static final String cookie = UUID.randomUUID().toString();

    public static void probe() {
    }

    public static void injectLatest(FileWriter writer) {
        List<File> potentialLogs = Arrays.asList(new File(Launch.minecraftHome, "logs/fml-client-latest.log"), new File(Launch.minecraftHome, "logs/fml-server-latest.log"));
        for (File file : potentialLogs) {
            try (FileInputStream is = new FileInputStream(file);){
                List<String> lines = CrashImprover.readLines(is);
                if (!lines.stream().anyMatch(l -> l.contains(cookie))) continue;
                writer.append("\n\n").append("Complete log:").append('\n');
                for (String line : lines) {
                    writer.append(line).append('\n');
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static List<String> readLines(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.toList());
    }

    static {
        FPLog.LOG.info("Magic cookie: {}", new Object[]{cookie});
    }
}

