/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mapping.types;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import com.falsepattern.lib.mapping.storage.Lookup;
import com.falsepattern.lib.mapping.storage.MappedString;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.mapping.types.UniversalMethod;
import java.util.Map;
import lombok.Generated;

@StableAPI(since="0.10.0")
public class UniversalClass {
    public final MappedString internalName;
    public final MappedString regularName;
    private final Lookup<UniversalField> fields = new Lookup();
    private final Lookup<UniversalMethod> methods = new Lookup();
    private Class<?> javaClassCache = null;
    private MappingType realClassMapping = null;

    @StableAPI.Expose
    public UniversalClass(String[] names, Map<String, String> stringPool) {
        this.internalName = new MappedString(names, 0, 1, str -> str, stringPool);
        this.regularName = new MappedString(names, 0, 1, str -> str.replace('/', '.'), stringPool);
    }

    void addField(UniversalField field) {
        if (field.parent != this) {
            throw new IllegalArgumentException("Field's parent is not this class");
        }
        this.fields.unwrap(field.name, field);
    }

    void addMethod(UniversalMethod method) {
        if (method.parent != this) {
            throw new IllegalArgumentException("Method's parent is not this class");
        }
        this.methods.unwrap(method.fusedNameDescriptor, method);
    }

    @StableAPI.Expose
    public Class<?> asJavaClass() throws ClassNotFoundException {
        if (this.javaClassCache != null) {
            return this.javaClassCache;
        }
        if (!CoreLoadingPlugin.isObfuscated()) {
            this.javaClassCache = Class.forName(this.regularName.mcp);
            this.realClassMapping = MappingType.MCP;
        } else {
            try {
                this.javaClassCache = Class.forName(this.regularName.srg);
                this.realClassMapping = MappingType.SRG;
            }
            catch (ClassNotFoundException e) {
                try {
                    this.javaClassCache = Class.forName(this.regularName.notch);
                    this.realClassMapping = MappingType.Notch;
                }
                catch (ClassNotFoundException ex) {
                    throw e;
                }
            }
        }
        return this.javaClassCache;
    }

    @StableAPI.Expose
    public String getName(NameType nameType, MappingType mappingType) {
        switch (nameType) {
            case Internal: {
                return this.internalName.get(mappingType);
            }
            case Regular: {
                return this.regularName.get(mappingType);
            }
        }
        throw new IllegalArgumentException("Invalid enum value " + (Object)((Object)nameType));
    }

    @StableAPI.Expose
    public String getNameAsDescriptor(MappingType mappingType) {
        return "L" + this.getName(NameType.Internal, mappingType) + ";";
    }

    @StableAPI.Expose
    public UniversalField getField(MappingType mappingType, String fieldName) throws NoSuchFieldException {
        try {
            return this.fields.get(mappingType, fieldName);
        }
        catch (Lookup.LookupException e) {
            throw new NoSuchFieldException(e.getMessage());
        }
    }

    @StableAPI.Expose
    public UniversalMethod getMethod(MappingType mappingType, String methodName, String methodDescriptor) throws NoSuchMethodException {
        try {
            return this.methods.get(mappingType, methodName + methodDescriptor);
        }
        catch (Lookup.LookupException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
    }

    @Generated
    public String toString() {
        return "UniversalClass(internalName=" + this.internalName() + ", regularName=" + this.regularName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalClass)) {
            return false;
        }
        UniversalClass other = (UniversalClass)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MappedString this$internalName = this.internalName();
        MappedString other$internalName = other.internalName();
        if (this$internalName == null ? other$internalName != null : !((Object)this$internalName).equals(other$internalName)) {
            return false;
        }
        MappedString this$regularName = this.regularName();
        MappedString other$regularName = other.regularName();
        return !(this$regularName == null ? other$regularName != null : !((Object)this$regularName).equals(other$regularName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UniversalClass;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MappedString $internalName = this.internalName();
        result = result * 59 + ($internalName == null ? 43 : ((Object)$internalName).hashCode());
        MappedString $regularName = this.regularName();
        result = result * 59 + ($regularName == null ? 43 : ((Object)$regularName).hashCode());
        return result;
    }

    @StableAPI.Expose
    @Generated
    public MappedString internalName() {
        return this.internalName;
    }

    @StableAPI.Expose
    @Generated
    public MappedString regularName() {
        return this.regularName;
    }

    @Generated
    public MappingType realClassMapping() {
        return this.realClassMapping;
    }
}

