/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.toasts.icon;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.util.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
@StableAPI(since="0.10.0")
public abstract class ToastTexture {
    protected final IIcon icon;
    protected final ResourceLocation texture;

    @StableAPI.Expose
    public ToastTexture(@NonNull ResourceLocation texture, int width, int height) {
        this(texture, RenderUtil.getFullTextureIcon(texture.toString(), width, height));
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
    }

    @StableAPI.Expose
    public ToastTexture(@NonNull ResourceLocation texture, @NonNull IIcon icon) {
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        if (icon == null) {
            throw new NullPointerException("icon is marked non-null but is null");
        }
        this.icon = icon;
        this.texture = texture;
    }

    @StableAPI.Expose
    public abstract void draw(Gui var1, int var2, int var3);

    @StableAPI.Expose
    @Generated
    public IIcon getIcon() {
        return this.icon;
    }

    @StableAPI.Expose
    @Generated
    public ResourceLocation getTexture() {
        return this.texture;
    }
}

