/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.turboasm;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.turboasm.ClassHeaderMetadata;
import com.falsepattern.lib.turboasm.FastClassAccessor;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

@StableAPI(since="__EXPERIMENTAL__")
public final class ClassNodeHandle {
    private final byte @Nullable [] originalBytes;
    @Nullable
    private final ClassHeaderMetadata originalMetadata;
    private final int readerOptions;
    private boolean initialized = false;
    @Nullable
    private ClassNode node = null;
    @Nullable
    private FastClassAccessor accessor = null;
    private int writerFlags = 0;

    @StableAPI.Expose
    public ClassNodeHandle(byte @Nullable [] classData) {
        this(classData, 0);
    }

    @StableAPI.Expose
    public ClassNodeHandle(byte @Nullable [] classData, int readerOptions) {
        ClassHeaderMetadata originalMetadata;
        this.originalBytes = classData;
        if (classData == null) {
            originalMetadata = null;
        } else {
            try {
                originalMetadata = new ClassHeaderMetadata(classData);
            }
            catch (Exception e) {
                originalMetadata = null;
            }
        }
        this.originalMetadata = originalMetadata;
        this.accessor = originalMetadata;
        this.readerOptions = 0;
    }

    @StableAPI.Expose
    public byte @Nullable [] getOriginalBytes() {
        return this.originalBytes;
    }

    @StableAPI.Expose
    @Nullable
    public ClassHeaderMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    @StableAPI.Expose
    @Nullable
    public FastClassAccessor getFastAccessor() {
        return this.accessor;
    }

    @StableAPI.Expose
    public boolean isOriginal() {
        return !this.initialized;
    }

    @StableAPI.Expose
    public boolean isPresent() {
        if (this.initialized) {
            return this.node != null;
        }
        return this.originalBytes != null;
    }

    @StableAPI.Expose
    @Nullable
    public ClassNode getNode() {
        this.ensureInitialized();
        return this.node;
    }

    @StableAPI.Expose
    public void setNode(@Nullable ClassNode node) {
        this.initialized = true;
        this.node = node;
        this.accessor = node == null ? null : FastClassAccessor.ofAsmNode(node);
    }

    @StableAPI.Expose
    public byte @Nullable [] computeBytes() {
        if (!this.initialized) {
            return this.originalBytes;
        }
        if (this.node == null) {
            return null;
        }
        ClassWriter writer = new ClassWriter(this.writerFlags);
        this.node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @StableAPI.Expose
    public int getWriterFlags() {
        return this.writerFlags;
    }

    @StableAPI.Expose
    public void setWriterFlags(int flags) {
        this.writerFlags = flags;
    }

    @StableAPI.Expose
    public void orWriterFlags(int flags) {
        this.writerFlags |= flags;
    }

    @StableAPI.Expose
    public void computeMaxs() {
        this.writerFlags |= 1;
    }

    @StableAPI.Expose
    public void computeFrames() {
        this.writerFlags |= 2;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            if (this.originalBytes == null) {
                this.node = null;
                this.accessor = null;
            } else {
                this.node = new ClassNode();
                new ClassReader(this.originalBytes).accept((ClassVisitor)this.node, this.readerOptions);
                this.accessor = FastClassAccessor.ofAsmNode(this.node);
            }
            this.initialized = true;
        }
    }
}

