/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.turboasm;

import com.falsepattern.lib.StableAPI;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@StableAPI(since="__EXPERIMENTAL__")
public interface FastClassAccessor {
    @StableAPI.Expose
    public boolean isPublic();

    @StableAPI.Expose
    public boolean isFinal();

    @StableAPI.Expose
    public boolean isInterface();

    @StableAPI.Expose
    public boolean isAbstract();

    @StableAPI.Expose
    public boolean isSynthetic();

    @StableAPI.Expose
    public boolean isAnnotation();

    @StableAPI.Expose
    public boolean isEnum();

    @StableAPI.Expose
    @NotNull
    public String binaryThisName();

    @StableAPI.Expose
    @Nullable
    public String binarySuperName();

    @StableAPI.Expose
    public static OfLoaded ofLoaded(Class<?> loadedClass) {
        return new OfLoaded(loadedClass);
    }

    @StableAPI.Expose
    public static OfAsmNode ofAsmNode(ClassNode handle) {
        return new OfAsmNode(handle);
    }

    @StableAPI(since="__EXPERIMENTAL__")
    public static final class OfLoaded
    implements FastClassAccessor {
        public final Class<?> handle;

        private OfLoaded(Class<?> handle) {
            this.handle = handle;
        }

        @Override
        public boolean isPublic() {
            return Modifier.isPublic(this.handle.getModifiers());
        }

        @Override
        public boolean isFinal() {
            return Modifier.isFinal(this.handle.getModifiers());
        }

        @Override
        public boolean isInterface() {
            return Modifier.isInterface(this.handle.getModifiers());
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this.handle.getModifiers());
        }

        @Override
        public boolean isSynthetic() {
            return this.handle.isSynthetic();
        }

        @Override
        public boolean isAnnotation() {
            return this.handle.isAnnotation();
        }

        @Override
        public boolean isEnum() {
            return this.handle.isEnum();
        }

        @Override
        @NotNull
        public String binaryThisName() {
            return this.handle.getName().replace('.', '/');
        }

        @Override
        @Nullable
        public String binarySuperName() {
            Class<?> superclass = this.handle.getSuperclass();
            return superclass == null ? null : superclass.getName().replace('.', '/');
        }
    }

    @StableAPI(since="__EXPERIMENTAL__")
    public static final class OfAsmNode
    implements FastClassAccessor {
        public final ClassNode handle;

        public OfAsmNode(ClassNode handle) {
            this.handle = handle;
        }

        @Override
        public boolean isPublic() {
            return (this.handle.access & 1) != 0;
        }

        @Override
        public boolean isFinal() {
            return (this.handle.access & 0x10) != 0;
        }

        @Override
        public boolean isInterface() {
            return (this.handle.access & 0x200) != 0;
        }

        @Override
        public boolean isAbstract() {
            return (this.handle.access & 0x400) != 0;
        }

        @Override
        public boolean isSynthetic() {
            return (this.handle.access & 0x1000) != 0;
        }

        @Override
        public boolean isAnnotation() {
            return (this.handle.access & 0x2000) != 0;
        }

        @Override
        public boolean isEnum() {
            return (this.handle.access & 0x4000) != 0;
        }

        @Override
        @NotNull
        public String binaryThisName() {
            return this.handle.name;
        }

        @Override
        @Nullable
        public String binarySuperName() {
            return this.handle.superName;
        }
    }
}

