/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.turboasm;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lib.internal.asm.CoreLoadingPlugin;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TransformerUtil;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;

@StableAPI(since="__EXPERIMENTAL__")
public class MergeableTurboTransformer
implements IClassTransformer {
    private final List<TurboClassTransformer> transformers;

    public MergeableTurboTransformer(List<TurboClassTransformer> transformers) {
        this.transformers = new ArrayList<TurboClassTransformer>(transformers);
    }

    public final byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (this.transformers.isEmpty()) {
            return bytes;
        }
        ClassNodeHandle handle = new ClassNodeHandle(bytes);
        if (TransformerUtil.executeTransformers(transformedName, handle, this.transformers)) {
            return handle.computeBytes();
        }
        return bytes;
    }

    public static MergeableTurboTransformer merge(MergeableTurboTransformer a, MergeableTurboTransformer b) {
        ArrayList<TurboClassTransformer> arr = new ArrayList<TurboClassTransformer>(a.transformers);
        arr.addAll(b.transformers);
        return new MergeableTurboTransformer(arr);
    }

    public static void mergeAllTurboTransformers() {
        CoreLoadingPlugin.mergeTurboTransformers();
    }
}

