/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.quad;

import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFlags;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3f;

public class Quad
implements QuadView {
    public static final int VERTEX_STRIDE = 8;
    public static final int QUAD_STRIDE = 32;
    public static final int X_INDEX = 0;
    public static final int Y_INDEX = 1;
    public static final int Z_INDEX = 2;
    public static final int U_INDEX = 3;
    public static final int V_INDEX = 4;
    public static final int COLOR_INDEX = 5;
    public static final int NORMAL_INDEX = 6;
    public static final int LIGHTMAP_INDEX = 7;
    private static final int DEFAULT_LIGHTMAP = 0xF000F0;
    private static final int DEFAULT_COLOR = -1;
    protected final int[] data = new int[32];
    private boolean deleted = false;
    private final Vector3f vectorA = new Vector3f();
    private final Vector3f vectorB = new Vector3f();
    private final Vector3f vectorC = new Vector3f();
    private boolean shade;
    private int cachedFlags;
    private ForgeDirection face;
    private int colorIndex = -1;
    private TextureAtlasSprite sprite = null;

    @Override
    public ForgeDirection getLightFace() {
        return this.face != ForgeDirection.UNKNOWN ? this.face : ForgeDirection.UP;
    }

    @Override
    public ForgeDirection getCullFace() {
        return this.face;
    }

    @Override
    public float getX(int idx) {
        return Float.intBitsToFloat(this.data[idx * 8 + 0]);
    }

    @Override
    public float getY(int idx) {
        return Float.intBitsToFloat(this.data[idx * 8 + 1]);
    }

    @Override
    public float getZ(int idx) {
        return Float.intBitsToFloat(this.data[idx * 8 + 2]);
    }

    @Override
    public float getTexU(int idx) {
        return Float.intBitsToFloat(this.data[idx * 8 + 3]);
    }

    @Override
    public float getTexV(int idx) {
        return Float.intBitsToFloat(this.data[idx * 8 + 4]);
    }

    @Override
    public int getColor(int idx) {
        return this.data[idx * 8 + 5];
    }

    @Override
    public int getLight(int idx) {
        return this.data[idx * 8 + 7];
    }

    @Override
    public int getNormal(int idx) {
        return this.data[idx * 8 + 6];
    }

    @Override
    public int getFlags() {
        return this.cachedFlags;
    }

    @Override
    public int getColorIndex() {
        return this.colorIndex;
    }

    @Override
    public TextureAtlasSprite rubidium$getSprite() {
        return this.sprite;
    }

    @Override
    public void setCullFace(ForgeDirection face) {
        this.face = face;
    }

    @Override
    public void setX(int idx, float x) {
        this.data[idx * 8 + 0] = Float.floatToRawIntBits(x);
    }

    @Override
    public void setY(int idx, float y) {
        this.data[idx * 8 + 1] = Float.floatToRawIntBits(y);
    }

    @Override
    public void setZ(int idx, float z) {
        this.data[idx * 8 + 2] = Float.floatToRawIntBits(z);
    }

    @Override
    public void setTexU(int idx, float u) {
        this.data[idx * 8 + 3] = Float.floatToRawIntBits(u);
    }

    @Override
    public void setTexV(int idx, float v) {
        this.data[idx * 8 + 4] = Float.floatToRawIntBits(v);
    }

    @Override
    public void setColor(int idx, int c) {
        this.data[idx * 8 + 5] = c;
    }

    @Override
    public void setLight(int idx, int l) {
        this.data[idx * 8 + 7] = l;
    }

    @Override
    public void setNormal(int idx, int n) {
        this.data[idx * 8 + 6] = n;
    }

    @Override
    public void setFlags(int flags) {
        this.cachedFlags = flags;
    }

    @Override
    public void setColorIndex(int i) {
        this.colorIndex = i;
    }

    @Override
    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    @Override
    public int[] getRawData() {
        return this.data;
    }

    private float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + coordinateIndex]);
    }

    private void setPosByIndex(int vertexIndex, int coordinateIndex, float val) {
        this.data[vertexIndex * 8 + coordinateIndex] = Float.floatToRawIntBits(val);
    }

    private void offsetPos(int idx, float offset) {
        this.setPosByIndex(0, idx, this.posByIndex(0, idx) + offset);
        this.setPosByIndex(1, idx, this.posByIndex(1, idx) + offset);
        this.setPosByIndex(2, idx, this.posByIndex(2, idx) + offset);
        this.setPosByIndex(3, idx, this.posByIndex(3, idx) + offset);
    }

    private void clearNormals() {
        this.setNormal(0, 0);
        this.setNormal(1, 0);
        this.setNormal(2, 0);
        this.setNormal(3, 0);
    }

    private void clearLight() {
        this.setLight(0, 0xF000F0);
        this.setLight(1, 0xF000F0);
        this.setLight(2, 0xF000F0);
        this.setLight(3, 0xF000F0);
    }

    private boolean isEmpty() {
        return this.getX(0) == this.getX(1) && this.getX(1) == this.getX(2) && this.getX(2) == this.getX(3) && this.getY(0) == this.getY(1) && this.getY(1) == this.getY(2) && this.getY(2) == this.getY(3);
    }

    private void calcNormal() {
        this.vectorA.set(this.getX(1) - this.getX(0), this.getY(1) - this.getY(0), this.getZ(1) - this.getZ(0));
        this.vectorB.set(this.getX(2) - this.getX(1), this.getY(2) - this.getY(1), this.getZ(2) - this.getZ(1));
        this.vectorA.cross(this.vectorB, this.vectorC);
    }

    protected void quadrangulate() {
        this.setX(3, this.getX(2));
        this.setY(3, this.getY(2));
        this.setZ(3, this.getZ(2));
        this.setTexU(3, this.getTexU(2));
        this.setTexV(3, this.getTexV(2));
        this.setLight(3, this.getLight(2));
        this.setColor(3, this.getColor(2));
        this.setNormal(3, this.getNormal(2));
    }

    @Override
    public QuadView copyFrom(QuadView quad) {
        System.arraycopy(quad.getRawData(), 0, this.data, 0, 32);
        this.deleted = quad.isDeleted();
        this.shade = quad.isShade();
        this.face = quad.getFace();
        this.colorIndex = quad.getColorIndex();
        this.cachedFlags = quad.getFlags();
        this.sprite = quad.rubidium$getSprite();
        return this;
    }

    private void read(int[] rawBuffer, int offset, float offsetX, float offsetY, float offsetZ, int drawMode, Flags flags) {
        System.arraycopy(rawBuffer, offset, this.data, 0, 32);
        if (offsetX != 0.0f) {
            this.offsetPos(0, offsetX);
        }
        if (offsetY != 0.0f) {
            this.offsetPos(1, offsetY);
        }
        if (offsetZ != 0.0f) {
            this.offsetPos(2, offsetZ);
        }
        if (!flags.hasColor) {
            this.setColors(-1);
        }
        if (!flags.hasNormals) {
            this.clearNormals();
        }
        if (!flags.hasBrightness) {
            this.clearLight();
        }
        this.shade = flags.hasBrightness;
        if (drawMode == 4) {
            this.quadrangulate();
        }
    }

    @Override
    public void setState(int[] rawBuffer, int offset, Flags flags, int drawMode, float offsetX, float offsetY, float offsetZ) {
        this.deleted = false;
        this.read(rawBuffer, offset, offsetX, offsetY, offsetZ, drawMode, flags);
        if (this.isEmpty()) {
            this.deleted = true;
            return;
        }
        this.calcNormal();
        this.face = ModelQuadFacing.toDirection(ModelQuadFacing.fromVector(this.vectorC));
        this.cachedFlags = ModelQuadFlags.getQuadFlags(this);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s[(%.1f, %.1f, %.1f), (%.1f, %.1f, %.1f), (%.1f, %.1f, %.1f), (%.1f, %.1f, %.1f)]", this.deleted ? "XXX " : "", Float.valueOf(this.getX(0)), Float.valueOf(this.getY(0)), Float.valueOf(this.getZ(0)), Float.valueOf(this.getX(1)), Float.valueOf(this.getY(1)), Float.valueOf(this.getZ(1)), Float.valueOf(this.getX(2)), Float.valueOf(this.getY(2)), Float.valueOf(this.getZ(2)), Float.valueOf(this.getX(3)), Float.valueOf(this.getY(3)), Float.valueOf(this.getZ(3)));
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    @Generated
    public boolean isShade() {
        return this.shade;
    }

    @Override
    @Generated
    public ForgeDirection getFace() {
        return this.face;
    }

    public static class Flags {
        boolean hasTexture;
        public boolean hasBrightness;
        public boolean hasColor;
        public boolean hasNormals;

        public Flags(byte flags) {
            this.hasTexture = (flags & 1) != 0;
            this.hasBrightness = (flags & 2) != 0;
            this.hasColor = (flags & 4) != 0;
            this.hasNormals = (flags & 8) != 0;
        }

        public Flags(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }

        public byte toByte() {
            byte flags = 0;
            if (this.hasTexture) {
                flags = (byte)(flags | 1);
            }
            if (this.hasBrightness) {
                flags = (byte)(flags | 2);
            }
            if (this.hasColor) {
                flags = (byte)(flags | 4);
            }
            if (this.hasNormals) {
                flags = (byte)(flags | 8);
            }
            return flags;
        }
    }
}

