/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.tooltip;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.client.tooltip.LoreHolderDiscoverer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;
import org.apache.commons.lang3.StringUtils;

public final class LoreHandler
implements IResourceManagerReloadListener {
    private static final Random RANDOM = new Random();

    public static void postInit() {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new LoreHandler());
    }

    private LoreHandler() {
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        LoreHolderDiscoverer.LORE_HOLDERS.forEach((field, keyPrefix) -> {
            try {
                field.setValue(null, LoreHandler.getRandomLine(keyPrefix));
            }
            catch (Exception e) {
                GTNHLib.LOG.warn("Unable to update LoreHolder in " + field.javaField.getDeclaringClass() + " (Field: " + field.javaField.getName() + ")", (Throwable)e);
            }
        });
    }

    @Deprecated
    public static void registerLoreHolder(Class<?> clazz) {
    }

    private static String getRandomLine(String keyPrefix) {
        List<WeightedRandom.Item> lines = LoreHandler.getAllLines(keyPrefix);
        if (lines.size() == 0) {
            return null;
        }
        try {
            return ((WeightedText)WeightedRandom.func_76271_a((Random)RANDOM, lines)).text;
        }
        catch (IllegalArgumentException e) {
            GTNHLib.LOG.warn("The total weight of all lines for \"" + keyPrefix + "\" exceeds " + Integer.MAX_VALUE, (Throwable)e);
        }
        catch (Exception e) {
            GTNHLib.LOG.error("An unexpected Exception occurred while choosing a random lore for \"" + keyPrefix + '\"', (Throwable)e);
        }
        return null;
    }

    private static List<WeightedRandom.Item> getAllLines(String keyPrefix) {
        String localizedLine;
        String unlocalizedLine;
        ArrayList<WeightedRandom.Item> allLines = new ArrayList<WeightedRandom.Item>();
        int i = 0;
        while (!(unlocalizedLine = keyPrefix + i).equals(localizedLine = StatCollector.func_74838_a((String)unlocalizedLine))) {
            if (!StringUtils.isBlank((CharSequence)localizedLine)) {
                allLines.add(new WeightedText(localizedLine));
            }
            ++i;
        }
        return allLines;
    }

    private static class WeightedText
    extends WeightedRandom.Item {
        private String text;

        private WeightedText(String weightedText) {
            super(0);
            this.extractWeightAndText(weightedText);
        }

        private void extractWeightAndText(String weightedText) {
            int endOfWeight = weightedText.indexOf(58);
            if (endOfWeight < 1) {
                this.field_76292_a = 1;
                this.text = weightedText;
                return;
            }
            if (weightedText.charAt(endOfWeight - 1) == '\\') {
                this.field_76292_a = 1;
                this.text = weightedText.substring(0, endOfWeight - 1) + weightedText.substring(endOfWeight);
                return;
            }
            String weightString = weightedText.substring(0, endOfWeight);
            try {
                int weight = Integer.parseInt(weightString);
                if (weight < 0) {
                    GTNHLib.LOG.warn("\"{}\" has a negative weight ({}). This is not allowed, a weight of 1 will be used instead.", new Object[]{weightedText, weight});
                    this.field_76292_a = 1;
                } else {
                    this.field_76292_a = weight;
                }
                this.text = weightedText.substring(endOfWeight + 1);
                return;
            }
            catch (NumberFormatException e) {
                GTNHLib.LOG.warn("Could not parse \"" + weightString + "\" as Integer. If it is not supposed to be a weight, escape the ':' delimiter using '\\'.", (Throwable)e);
            }
            catch (Exception e) {
                GTNHLib.LOG.error("An unexpected Exception occurred while extracting weight and text from lore \"" + weightedText + '\"', (Throwable)e);
            }
            this.field_76292_a = 1;
            this.text = weightedText;
        }
    }
}

