/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhmixins.core.GTNHMixinsCore;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.config.ASMConfig;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.SpeedupsConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.mixins.TargetedMod;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public enum AsmTransformers {
    SPEEDUP_PROGRESS_BAR("Speed up Progress Bar by speeding up stripSpecialCharacters", () -> ASMConfig.speedupProgressBar, Side.CLIENT, "com.mitchej123.hodgepodge.asm.transformers.fml.SpeedupProgressBarTransformer"),
    SPEEDUP_LONG_INT_HASHMAP("Speed up LongHashMap & IntHashMap", () -> ASMConfig.speedupLongIntHashMap, Side.BOTH, null, (List<TargetedMod>)ImmutableList.of((Object)((Object)TargetedMod.FASTCRAFT), (Object)((Object)TargetedMod.BUKKIT)), "com.mitchej123.hodgepodge.asm.transformers.mc.SpeedupLongIntHashMapTransformer"),
    SPEEDUP_NBT_TAG_COMPOUND_COPY("Speed up NBTTagCompound.copy()", () -> ASMConfig.speedupNBTTagCompoundCopy, Side.BOTH, null, (List<TargetedMod>)ImmutableList.of((Object)((Object)TargetedMod.FASTCRAFT), (Object)((Object)TargetedMod.BUKKIT)), "com.mitchej123.hodgepodge.asm.transformers.mc.NBTTagCompoundHashMapTransformer"),
    FIX_BOGUS_INTEGRATED_SERVER_NPE("Fix bogus FMLProxyPacket NPEs on integrated server crashes", () -> FixesConfig.fixBogusIntegratedServerNPEs, Side.BOTH, "com.mitchej123.hodgepodge.asm.transformers.fml.FMLIndexedMessageToMessageCodecTransformer"),
    THERMOS_SLEDGEHAMMER_FURNACE_FIX("Take a sledgehammer to CraftServer.resetRecipes() to prevent it from breaking our Furnace Fix", () -> Common.thermosTainted && SpeedupsConfig.speedupVanillaFurnace, Side.BOTH, "com.mitchej123.hodgepodge.asm.transformers.thermos.ThermosFurnaceSledgeHammer"),
    OPTIFINE_REMOVE_GLERROR_LOGGING("Removes the logging of GL errors from OptiFine/Shadersmod", () -> TweaksConfig.removeOptifineGLErrors, Side.CLIENT, "com.mitchej123.hodgepodge.asm.transformers.optifine.GLErrorLoggingTransformer");

    private final Supplier<Boolean> applyIf;
    private final Side side;
    private final String[] transformerClasses;
    private final List<TargetedMod> targetedMods;
    private final List<TargetedMod> excludedMods;

    private AsmTransformers(String description, Supplier<Boolean> applyIf, Side side, String ... transformers) {
        this.applyIf = applyIf;
        this.side = side;
        this.transformerClasses = transformers;
        this.targetedMods = new ArrayList<TargetedMod>();
        this.excludedMods = new ArrayList<TargetedMod>();
    }

    private AsmTransformers(String description, Supplier<Boolean> applyIf, Side side, List<TargetedMod> targetedMods, List<TargetedMod> excludedMods, String ... transformers) {
        this.applyIf = applyIf;
        this.side = side;
        this.transformerClasses = transformers;
        this.targetedMods = targetedMods;
        this.excludedMods = excludedMods;
    }

    private boolean shouldBeLoaded(Set<String> loadedCoreMods) {
        if (loadedCoreMods == null) {
            loadedCoreMods = Collections.emptySet();
        }
        return this.applyIf.get() != false && this.shouldLoadSide() && this.allModsLoaded(this.targetedMods, loadedCoreMods) && this.noModsLoaded(this.excludedMods, loadedCoreMods);
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods) {
        if (targetedMods == null || targetedMods.isEmpty()) {
            return true;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA || loadedCoreMods.isEmpty() || target.coreModClass == null || loadedCoreMods.contains(target.coreModClass)) continue;
            return false;
        }
        return true;
    }

    private boolean noModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods) {
        if (targetedMods == null || targetedMods.isEmpty()) {
            return true;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA || loadedCoreMods.isEmpty() || target.coreModClass == null || !loadedCoreMods.contains(target.coreModClass)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    public static String[] getTransformers() {
        Set coremods;
        try {
            Field loadPlugins = CoreModManager.class.getDeclaredField("loadPlugins");
            loadPlugins.setAccessible(true);
            List loadedCoremods = (List)loadPlugins.get(null);
            Class<?> mixinCore = Class.forName("com.gtnewhorizon.gtnhmixins.core.GTNHMixinsCore");
            Method getLoadedCoremods = mixinCore.getDeclaredMethod("getLoadedCoremods", List.class);
            getLoadedCoremods.setAccessible(true);
            coremods = (Set)getLoadedCoremods.invoke((Object)new GTNHMixinsCore(), loadedCoremods);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> transformerList = new ArrayList<String>();
        for (AsmTransformers transformer : AsmTransformers.values()) {
            if (transformer.shouldBeLoaded(coremods)) {
                Common.log.info("Loading transformer {}", (Object[])transformer.transformerClasses);
                transformerList.addAll(Arrays.asList(transformer.transformerClasses));
                continue;
            }
            Common.log.info("Not loading transformer {}", (Object[])transformer.transformerClasses);
        }
        return transformerList.toArray(new String[0]);
    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

