/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.hax;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;

public class FastIntCache {
    private static final int SMALLEST = 256;
    private static final int MIN_LEVEL = 32 - Integer.numberOfLeadingZeros(255);
    private static final Map<Integer, List<int[]>> cachedObjects = new Int2ObjectOpenHashMap();

    public static synchronized int[] getCache(int size) {
        int level = size <= 256 ? MIN_LEVEL : 32 - Integer.numberOfLeadingZeros(size - 1);
        List caches = cachedObjects.computeIfAbsent(level, i -> new ObjectArrayList());
        if (caches.isEmpty()) {
            return new int[2 << level - 1];
        }
        return (int[])caches.remove(caches.size() - 1);
    }

    public static synchronized void releaseCache(int[] cache) {
        int level = cache.length <= 256 ? MIN_LEVEL : 32 - Integer.numberOfLeadingZeros(cache.length - 1);
        cachedObjects.computeIfAbsent(level, i -> new ObjectArrayList()).add(cache);
    }
}

