/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.fml;

import com.google.common.base.Charsets;
import com.mitchej123.hodgepodge.Common;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LanguageRegistry.class})
public class MixinLanguageRegistry {
    @Inject(method={"loadLanguagesFor"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void hodgepodge$injectLanguagesFor(ModContainer container, Side side, CallbackInfo ci) {
        if ("IC2".equals(container.getModId())) {
            try {
                this.hodgepodge$loadLanguagesForIC2(container);
            }
            catch (IOException e) {
                Common.log.error("Failed to load IC2 translations.");
                Common.log.catching((Throwable)e);
            }
            ci.cancel();
        }
    }

    @Unique
    private void hodgepodge$loadLanguagesForIC2(ModContainer container) throws IOException {
        File source = container.getSource();
        try (ZipFile zipFile = new ZipFile(source);){
            for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                String fileName;
                String name = zipEntry.getName();
                if (!name.startsWith("ic2/lang/") || (fileName = name.substring("ic2/lang/".length())).contains("/") || !fileName.endsWith(".properties")) continue;
                InputStream is = zipFile.getInputStream(zipEntry);
                try {
                    MixinLanguageRegistry.hodgepodge$loadIC2Localization(is, fileName.split("\\.")[0]);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            Common.log.debug("Loaded IC2 translations from file {}.", new Object[]{source});
        }
    }

    @Unique
    private static void hodgepodge$loadIC2Localization(InputStream inputStream, String lang) throws IOException {
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, Charsets.UTF_8));
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entries : properties.entrySet()) {
            Object key = entries.getKey();
            Object value = entries.getValue();
            if (!(key instanceof String)) continue;
            String stringKey = (String)key;
            if (!(value instanceof String)) continue;
            String stringValue = (String)value;
            if (!(stringKey.startsWith("achievement.") || stringKey.startsWith("itemGroup.") || stringKey.startsWith("death."))) {
                stringKey = "ic2." + stringKey;
            }
            map.put(stringKey, stringValue);
        }
        LanguageRegistry.instance().injectLanguage(lang, map);
    }
}

