/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.late.hungeroverhaul;

import com.mitchej123.hodgepodge.Common;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.IguanaEventHook;
import iguanaman.hungeroverhaul.util.RandomHelper;
import java.util.Random;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={IguanaEventHook.class}, remap=false)
public class MixinHungerOverhaulLowStatEffect {
    @Overwrite
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityAnimal) {
            NBTTagCompound tags;
            float rndBreed = RandomHelper.nextFloat((Random)Common.RNG, (float)IguanaConfig.breedingTimeoutMultiplier);
            float rndChild = RandomHelper.nextFloat((Random)Common.RNG, (float)IguanaConfig.childDurationMultiplier);
            EntityAgeable ageable = (EntityAgeable)event.entityLiving;
            int growingAge = ageable.func_70874_b();
            if (growingAge > 0 && rndBreed >= 1.0f) {
                ageable.func_70873_a(++growingAge);
            } else if (growingAge < 0 && rndChild >= 1.0f) {
                ageable.func_70873_a(--growingAge);
            }
            if (IguanaConfig.eggTimeoutMultiplier > 1.0f && event.entityLiving instanceof EntityChicken) {
                float rnd = RandomHelper.nextFloat((Random)Common.RNG, (float)IguanaConfig.eggTimeoutMultiplier);
                EntityChicken chicken = (EntityChicken)event.entityLiving;
                if (chicken.field_70887_j > 0 && rnd >= 1.0f) {
                    ++chicken.field_70887_j;
                }
            }
            if (IguanaConfig.milkedTimeout > 0 && event.entityLiving instanceof EntityCow && event.entityLiving.field_70170_p.func_82737_E() % 20L == 0L && (tags = event.entityLiving.getEntityData()).func_74764_b("Milked")) {
                int milked = tags.func_74762_e("Milked");
                if (--milked <= 0) {
                    tags.func_82580_o("Milked");
                } else {
                    tags.func_74768_a("Milked", milked);
                }
            }
        }
        if (!event.entityLiving.field_70170_p.field_72995_K && event.entityLiving instanceof EntityPlayer) {
            NBTTagCompound tags = event.entityLiving.getEntityData();
            if (tags.func_74764_b("HungerOverhaulCheck")) {
                int lastCheck = tags.func_74762_e("HungerOverhaulCheck");
                if (--lastCheck <= 0) {
                    tags.func_82580_o("HungerOverhaulCheck");
                } else {
                    tags.func_74768_a("HungerOverhaulCheck", lastCheck);
                }
            } else {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                float healthPercent = Math.min(player.func_110143_aJ(), 20.0f) / Math.min(player.func_110138_aP(), 20.0f);
                int foodLevel = Math.max(player.func_71024_bL().func_75116_a(), 1);
                boolean creative = player.field_71075_bZ.field_75098_d;
                if (IguanaConfig.constantHungerLoss && !creative && !player.field_70128_L) {
                    player.func_71020_j(0.01f);
                }
                if (IguanaConfig.addLowStatEffects) {
                    int difficultyModifierEffects = 2;
                    if (IguanaConfig.difficultyScalingEffects && event.entityLiving.field_70170_p.field_73013_u != null) {
                        difficultyModifierEffects = event.entityLiving.field_70170_p.field_73013_u.func_151525_a();
                    }
                    if (!creative && !event.entityLiving.field_70128_L && healthPercent > 0.0f) {
                        int moveSlowDown = 0;
                        int digSlowDown = 0;
                        int weakness = 0;
                        if (foodLevel <= 5) {
                            if (IguanaConfig.addLowHungerSlowness) {
                                moveSlowDown = 6 - foodLevel;
                            }
                            if (IguanaConfig.addLowHungerMiningSlowdown) {
                                digSlowDown = 6 - foodLevel;
                            }
                            if (IguanaConfig.addLowHungerWeakness) {
                                weakness = Math.max(0, 4 - foodLevel);
                            }
                        }
                        if (!(healthPercent > 0.25f)) {
                            if (healthPercent <= 0.05f) {
                                if (IguanaConfig.addLowHealthSlowness) {
                                    moveSlowDown = 5;
                                }
                                if (IguanaConfig.addLowHealthMiningSlowdown) {
                                    digSlowDown = 5;
                                }
                                if (IguanaConfig.addLowHealthWeakness) {
                                    weakness = 3;
                                }
                            } else if (healthPercent <= 0.1f) {
                                if (IguanaConfig.addLowHealthSlowness) {
                                    moveSlowDown = Math.max(moveSlowDown, 4);
                                }
                                if (IguanaConfig.addLowHealthMiningSlowdown) {
                                    digSlowDown = Math.max(digSlowDown, 4);
                                }
                                if (IguanaConfig.addLowHealthWeakness) {
                                    weakness = Math.max(weakness, 2);
                                }
                            } else if (healthPercent <= 0.15f) {
                                if (IguanaConfig.addLowHealthSlowness) {
                                    moveSlowDown = Math.max(moveSlowDown, 3);
                                }
                                if (IguanaConfig.addLowHealthMiningSlowdown) {
                                    digSlowDown = Math.max(digSlowDown, 3);
                                }
                                if (IguanaConfig.addLowHealthWeakness) {
                                    weakness = Math.max(weakness, 1);
                                }
                            } else if (healthPercent <= 0.2f) {
                                if (IguanaConfig.addLowHealthSlowness) {
                                    moveSlowDown = Math.max(moveSlowDown, 2);
                                }
                                if (IguanaConfig.addLowHealthMiningSlowdown) {
                                    digSlowDown = Math.max(digSlowDown, 2);
                                }
                            } else if (healthPercent <= 0.25f) {
                                if (IguanaConfig.addLowHealthSlowness) {
                                    moveSlowDown = Math.max(moveSlowDown, 1);
                                }
                                if (IguanaConfig.addLowHealthMiningSlowdown) {
                                    digSlowDown = Math.max(digSlowDown, 1);
                                }
                            }
                        }
                        if (moveSlowDown != 0 && difficultyModifierEffects >= -moveSlowDown + 4) {
                            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 19, -4 + moveSlowDown + difficultyModifierEffects, true));
                        }
                        if (digSlowDown != 0 && difficultyModifierEffects >= -digSlowDown + 4) {
                            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 19, -4 + digSlowDown + difficultyModifierEffects, true));
                        }
                        if (weakness != 0 && difficultyModifierEffects >= -weakness + 4) {
                            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 19, -4 + weakness + difficultyModifierEffects, true));
                        }
                        if (IguanaConfig.addLowHungerNausea && foodLevel <= 1 || IguanaConfig.addLowHealthNausea && healthPercent <= 0.05f) {
                            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 19, 0, true));
                        }
                    }
                }
                tags.func_74768_a("HungerOverhaulCheck", 9);
            }
        }
    }
}

