/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.chooser;

import com.github.weisj.darklaf.components.chooser.ChooserComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListChooser<T>
extends JPanel
implements ChooserComponent<T> {
    protected final JList<T> listComp;
    private final List<T> values;
    private T initial;
    private Consumer<T> callback;

    public ListChooser(List<T> values) {
        super(new BorderLayout());
        this.values = values;
        DefaultListModel model = new DefaultListModel();
        values.forEach(model::addElement);
        this.listComp = new JList(model);
        this.listComp.addListSelectionListener(e -> {
            if (this.callback != null) {
                this.callback.accept(this.listComp.getSelectedValue());
            }
        });
        this.add(new JScrollPane(this.listComp));
        this.setOpaque(false);
    }

    @Override
    public void reset(T initial, Consumer<T> callback) {
        this.initial = initial;
        this.callback = callback;
        if (initial != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                T value = this.values.get(i);
                if (value == null || !value.equals(initial)) continue;
                this.listComp.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public T getInitial() {
        return this.initial;
    }

    @Override
    public T getSelected() {
        return this.listComp.getSelectedValue();
    }

    @Override
    public Color getBackground() {
        return this.listComp != null ? this.listComp.getBackground() : super.getBackground();
    }
}

