/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.DerivableIcon;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.icons.ImageSource;
import com.github.weisj.darklaf.properties.icons.RotateIcon;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Scale;
import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.ParserProvider;
import com.github.weisj.swingdsl.visualpadding.VisualPaddingProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class DarkSVGIcon
implements DerivableIcon<DarkSVGIcon>,
IconLoader.CacheableIcon,
RotateIcon,
Serializable,
ImageSource,
VisualPaddingProvider {
    private static final Logger LOGGER = LogUtil.getLogger(DarkSVGIcon.class);
    private static final double extraScale = 2.0;
    @NotNull
    private final Dimension iconSize;
    @NotNull
    private final SVGDocumentHolder svgDocumentHolder;
    private IconLoader.IconKey iconKey;
    private boolean directRendering;
    private boolean loadedWithExtraScale;
    private double scaleX;
    private double scaleY;
    private Image image;

    public DarkSVGIcon(@NotNull URI uri, int displayWidth, int displayHeight) {
        this.svgDocumentHolder = new SVGDocumentHolder(uri);
        this.iconSize = new Dimension(displayWidth, displayHeight);
    }

    protected DarkSVGIcon(int width, int height, DarkSVGIcon parent) {
        this.iconSize = new Dimension(width, height);
        this.svgDocumentHolder = parent.svgDocumentHolder;
    }

    @Override
    public void setCacheKey(IconLoader.IconKey key) {
        this.iconKey = key;
    }

    IconLoader.IconKey getCacheKey() {
        return this.iconKey;
    }

    @Override
    public DarkSVGIcon derive(int width, int height) {
        if (width == this.getIconWidth() && height == this.getIconHeight()) {
            return this;
        }
        return new DarkSVGIcon(width, height, this);
    }

    public void setDisplaySize(int width, int height) {
        if (this.iconKey != null) {
            this.iconKey.w = width;
            this.iconKey.h = height;
        }
        this.iconSize.setSize(width, height);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintIcon(c, g, x, y, 0.0);
    }

    protected boolean ensureLoaded(boolean painting) {
        return this.svgDocumentHolder.ensureLoaded(this);
    }

    @NotNull
    protected ParserProvider createParserProvider() {
        return new DefaultParserProvider();
    }

    protected void updateCache(boolean update, Component c) {
        GraphicsConfiguration gc = c != null ? c.getGraphicsConfiguration() : null;
        double sx = Scale.getScaleX(gc);
        double sy = Scale.getScaleY(gc);
        if (!update && Scale.equalWithError(this.scaleX, sx) && Scale.equalWithError(this.scaleY, sy) && this.image != null) {
            return;
        }
        this.scaleX = sx;
        this.scaleY = sy;
        double effectiveScaleX = this.loadedWithExtraScale ? this.scaleX * 2.0 : this.scaleX;
        double effectiveScaleY = this.loadedWithExtraScale ? this.scaleY * 2.0 : this.scaleY;
        LOGGER.finer(() -> String.format("Creating Image with size (w=%s, h=%s, scaleW=%s, scaleH=%s) for icon '%s'", this.getSize().width, this.getSize().height, effectiveScaleX, effectiveScaleX, this.getName(this.getURI())));
        this.image = this.createImage(Scale.scale(effectiveScaleX, effectiveScaleY, this.getSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image createImage(Dimension size) {
        this.ensureLoaded(false);
        BufferedImage bi = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Object aaHint = UIManager.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
            }
            this.svgDocumentHolder.svgDocument.render(null, g, new ViewBox(0.0f, 0.0f, size.width, size.height));
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Exception while painting '" + this.getURI().toASCIIString() + "'.", e);
        }
        finally {
            g.dispose();
        }
        return bi;
    }

    protected String getName(URI uri) {
        String name = uri.toASCIIString();
        name = name.substring(Math.min(name.length() - 1, name.lastIndexOf(47) + 1));
        return name;
    }

    protected void ensureImageLoaded(Component c, double rotation) {
        this.loadedWithExtraScale = !this.isExactRotation(rotation);
        this.updateCache(this.ensureLoaded(true) || this.loadedWithExtraScale, c);
    }

    private boolean isExactRotation(double rotation) {
        double r = rotation;
        if (r < 0.0) {
            r += Math.PI * 2;
        }
        if (r > Math.PI * 2) {
            r -= Math.PI * 2;
        }
        return Scale.equalWithError(r, 0.0) || Scale.equalWithError(r, 1.5707963267948966) || Scale.equalWithError(r, Math.PI) || Scale.equalWithError(r, 4.71238898038469);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, double rotation) {
        boolean dr = this.isDirectRenderingMode();
        if (dr) {
            this.ensureLoaded(true);
        } else {
            this.ensureImageLoaded(c, rotation);
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        g2.translate(x, y);
        Dimension size = this.getSize();
        double imageWidth = dr ? (double)size.width : (double)this.image.getWidth(null);
        double imageHeight = dr ? (double)size.height : (double)this.image.getHeight(null);
        double sx = (double)size.width / imageWidth;
        double sy = (double)size.height / imageHeight;
        if (!dr) {
            g2.scale(sx, sy);
        }
        if (rotation != 0.0) {
            g2.rotate(rotation, imageWidth / 2.0, imageHeight / 2.0);
        }
        if (dr) {
            SVGDocument svg = this.getSVGDocument();
            svg.render((JComponent)c, (Graphics2D)g, new ViewBox(0.0f, 0.0f, size.width, size.height));
        } else {
            g2.drawImage(this.image, 0, 0, c);
            g2.scale(1.0 / sx, 1.0 / sy);
        }
        g2.translate(-x, -y);
        g2.setTransform(transform);
    }

    public boolean isDirectRenderingMode() {
        return this.directRendering;
    }

    public void setDirectRenderingMode(boolean directRendering) {
        this.directRendering = directRendering;
    }

    @Override
    public int getIconWidth() {
        this.ensureSizeLoaded();
        return this.getSize().width;
    }

    @Override
    public int getIconHeight() {
        return this.getSize().height;
    }

    protected Dimension getSize() {
        this.ensureSizeLoaded();
        return this.iconSize;
    }

    private void ensureSizeLoaded() {
        if (this.iconSize.width < 0 || this.iconSize.height < 0) {
            SVGDocument svg = this.getSVGDocument();
            FloatSize svgSize = svg.size();
            int width = (int)((double)svgSize.width + 0.5);
            int height = (int)((double)svgSize.height + 0.5);
            if (this.iconSize.height < 0 && this.iconSize.width >= 0) {
                height = (int)((double)(this.iconSize.width * height) / (double)width);
                width = this.iconSize.width;
            } else if (this.iconSize.height >= 0 && this.iconSize.width < 0) {
                width = (int)((double)(this.iconSize.height * width) / (double)height);
                height = this.iconSize.height;
            } else if (this.iconSize.width == this.iconSize.height && this.iconSize.height < -1) {
                int size = Math.abs(this.iconSize.width);
                if (width == height) {
                    width = size;
                    height = size;
                } else if (width > height) {
                    height = (int)((double)(size * height) / (double)width);
                    width = size;
                } else {
                    width = (int)((double)(size * width) / (double)height);
                    height = size;
                }
            }
            this.setDisplaySize(width, height);
            LOGGER.finer(() -> "Inferred size of icon '" + this.getName(this.getURI()) + "' to " + this.iconSize);
        }
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocumentHolder.svgDocument(this);
    }

    @Override
    @NotNull
    public Insets getVisualPaddings(@NotNull Component component) {
        return this.svgDocumentHolder.visualPaddings(this);
    }

    void setVisualPadding(Insets visualPadding) {
        this.svgDocumentHolder.visualPadding = visualPadding;
    }

    public URI getURI() {
        return this.svgDocumentHolder.uri;
    }

    public String toString() {
        return "DarkSVGIcon{, svgDocumentHolder=" + this.svgDocumentHolder + ", iconSize=" + this.iconSize + ", iconKey=" + this.iconKey + ", directRendering=" + this.directRendering + ", loadedWithExtraScale=" + this.loadedWithExtraScale + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", image=" + this.image + '}';
    }

    private static class SVGDocumentHolder {
        @NotNull
        private final AtomicBoolean loaded = new AtomicBoolean();
        private SVGDocument svgDocument;
        @NotNull
        private final URI uri;
        private Insets visualPadding;

        private SVGDocumentHolder(@NotNull URI uri) {
            this(uri, (SVGDocument)null);
        }

        private SVGDocumentHolder(@NotNull URI uri, SVGDocument svgDocument) {
            this.uri = uri;
            this.svgDocument = svgDocument;
        }

        private boolean ensureLoaded(@NotNull DarkSVGIcon darkSVGIcon) {
            if (!this.loaded.get()) {
                URI iconUri = this.uri;
                LOGGER.finer(() -> "Loading icon '" + iconUri.toASCIIString() + "'.");
                try {
                    this.svgDocument = IconLoader.svgLoader().load(this.uri.toURL(), darkSVGIcon.createParserProvider());
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                Objects.requireNonNull(this.svgDocument, () -> "Document failed to load: " + iconUri.toASCIIString());
                this.loaded.set(true);
                return true;
            }
            return false;
        }

        @NotNull
        private SVGDocument svgDocument(@NotNull DarkSVGIcon darkSVGIcon) {
            this.ensureLoaded(darkSVGIcon);
            return this.svgDocument;
        }

        @NotNull
        private Insets visualPaddings(@NotNull DarkSVGIcon darkSVGIcon) {
            this.ensureLoaded(darkSVGIcon);
            return this.visualPadding != null ? this.visualPadding : new Insets(0, 0, 0, 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SVGDocumentHolder)) {
                return false;
            }
            SVGDocumentHolder that = (SVGDocumentHolder)o;
            return this.loaded.equals(that.loaded) && Objects.equals(this.svgDocument, that.svgDocument) && this.uri.equals(that.uri) && Objects.equals(this.visualPadding, that.visualPadding);
        }

        public int hashCode() {
            return Objects.hash(this.loaded, this.svgDocument, this.uri, this.visualPadding);
        }

        public String toString() {
            return "SVGDocumentHolder{loaded=" + this.loaded + ", svgDocument=" + this.svgDocument + ", uri=" + this.uri + ", visualPadding=" + this.visualPadding + '}';
        }
    }
}

